/*
 * Decompiled with CFR 0.152.
 */
package com.cwasa.javacv;

import com.cwasa.javacv.ClientForTesting;
import com.cwasa.javacv.JAVideoServiceCheckThread;
import com.cwasa.javacv.JAVideoServiceThread;
import com.cwasa.javacv.Logging;
import com.cwasa.javacv.VideoJobHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ServiceApp {
    public static final String VM_TAG = "JAVideoServiceApp";
    public static final String VERSION_TAG = "2022-06-26";
    public static final String SUFF = ".mp4";
    private static final int JOB_LIMIT = -1;
    public static final int IMG_TYPE = 5;
    private static final int TIMEOUT = -1;
    public static boolean DO_LOGGING = false;
    public static boolean DO_VIDEO = true;
    public static boolean DO_FRAMES = false;
    public static boolean DO_RUN_TEST_CLIENT = false;
    public static String TEST_PATH;
    private final Logging LOG = new Logging(){

        @Override
        public void log(String msg) {
            ServiceApp.this.txtLog.append(msg + "\r\n");
            ServiceApp.this.txtLog.setCaretPosition(ServiceApp.this.txtLog.getText().length());
        }

        @Override
        public void logt(String msg) {
            this.log(ServiceApp.VM_TAG + msg);
        }

        @Override
        public void logc(String msg) {
            if (DO_LOGGING) {
                this.log(msg);
            }
        }
    };
    private final JAVideoServiceThread.VideoRequestHandler VIDEO_REQUEST_HANDLER = this.makeVideoRequestHandler(this.LOG);
    private JAVideoServiceCheckThread checkThread;
    private JAVideoServiceThread serviceThread;
    private int nJobs;
    private boolean doneOneQuit = false;
    private JFrame frame;
    private JPanel content;
    private JTextArea txtLog;
    private JScrollPane scrollLog;
    public static final RenderingHints AA_HINTS;

    private static void log(String msg) {
        System.out.println(msg);
    }

    private static void logt(String msg) {
        ServiceApp.log(VM_TAG + msg);
    }

    private static void logc(String msg) {
        if (DO_LOGGING) {
            ServiceApp.log(msg);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, InvocationTargetException {
        ServiceApp.processArgs(args);
        ServiceApp videoapp = new ServiceApp();
        videoapp.startServiceApp();
    }

    private static void processArgs(String[] args) {
        boolean log = false;
        boolean test = false;
        String tpath = null;
        if (args != null) {
            for (String arg : args) {
                if (arg.startsWith("-")) {
                    if ("-log".startsWith(arg)) {
                        log = true;
                        continue;
                    }
                    if ("-test".startsWith(arg)) {
                        test = true;
                        continue;
                    }
                    ServiceApp.logt(": unknown argument setting: " + arg);
                    continue;
                }
                test = true;
                tpath = arg;
                if (arg.endsWith(SUFF)) continue;
                tpath = arg + SUFF;
                ServiceApp.logt(": test path adjusted: " + tpath);
            }
        }
        if (tpath == null) {
            tpath = "test-video.mp4";
        }
        TEST_PATH = tpath;
    }

    private JAVideoServiceThread.VideoRequestHandler makeVideoRequestHandler(final Logging LOG) {
        return new JAVideoServiceThread.VideoRequestHandler(){
            private final String PFX = "VideoRequestHandler.processRequest()";
            private final String VJH = " VideoJobHandler:";

            private void log(String msg) {
                LOG.log("VideoRequestHandler.processRequest()" + msg);
            }

            private void logvjhfail(String reason) {
                this.log(" VideoJobHandler: " + reason);
            }

            @Override
            public synchronized void processRequest(Socket ccsckt) {
                this.log(" starts at " + new Date() + ".");
                try {
                    VideoJobHandler videoJobHandler = new VideoJobHandler(ccsckt, LOG);
                }
                catch (InterruptedException ix) {
                    this.logvjhfail(ix.toString());
                    for (StackTraceElement ste : ix.getStackTrace()) {
                        LOG.log(ste.toString());
                    }
                    Thread.currentThread().interrupt();
                }
                catch (IOException iox) {
                    this.logvjhfail(iox.toString());
                    for (StackTraceElement ste : iox.getStackTrace()) {
                        LOG.log(ste.toString());
                    }
                }
                this.log(" done.");
                ServiceApp.this.notifyJobDone();
            }
        };
    }

    public ServiceApp() throws InterruptedException, InvocationTargetException {
        Runnable RUN_SET_UP_GUI = new Runnable(){

            @Override
            public void run() {
                ServiceApp.this.makeGUI();
            }
        };
        EventQueue.invokeAndWait(RUN_SET_UP_GUI);
        try {
            this.nJobs = 0;
            this.checkThread = new JAVideoServiceCheckThread(this.LOG);
            this.serviceThread = new JAVideoServiceThread(this.VIDEO_REQUEST_HANDLER, this.LOG);
        }
        catch (IOException iox) {
            this.LOG.log("Failed to create MovieServiceThread:" + iox);
        }
    }

    public Logging getLogging() {
        return this.LOG;
    }

    public void startServiceApp() {
        if (this.serviceThread != null) {
            this.LOG.logt(" starts at " + new Date() + ".");
            this.serviceThread.start();
            this.checkThread.start();
        } else {
            this.LOG.logt(" failed to start at " + new Date() + ".");
        }
    }

    public void stopServiceApp() {
        try {
            this.checkThread.shutDown();
            this.serviceThread.shutDown();
            this.LOG.logt(" stop signal sent.");
            System.out.println("JAVideoServiceApp stop signal sent.");
        }
        catch (IOException iox) {
            this.LOG.logt(" stopServiceApp(): " + iox);
        }
    }

    private void notifyJobDone() {
        ++this.nJobs;
        if (-1 == this.nJobs) {
            this.stopServiceApp();
        }
    }

    private void doShutDown() {
        if (this.serviceThread != null) {
            this.LOG.logt(" shutting down.");
            this.stopServiceApp();
        }
    }

    private void doQuit() {
        if (this.doneOneQuit) {
            System.out.println("Extra doQuit().");
        } else {
            this.doneOneQuit = true;
            System.out.println("Quitting.");
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException ix) {
                Thread.currentThread().interrupt();
            }
            System.exit(0);
        }
    }

    public void doRunTestClient() {
        int W = 419;
        int H = 482;
        int FPS = 50;
        int N = 81;
        ClientForTesting.startTest(81, 419, 482, 50, TEST_PATH, this.getLogging());
    }

    protected Font getLogFont() {
        String NICE_MONOSPACED = "Lucida Console";
        String[] ffnames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int NF = ffnames.length;
        int i = 0;
        int ii = NF;
        while (i != ii) {
            if (ffnames[i].equals(NICE_MONOSPACED)) {
                ii = i;
                continue;
            }
            ++i;
        }
        String fname = ii != NF ? NICE_MONOSPACED : "Monospaced";
        return new Font(fname, 0, 12);
    }

    protected void makeGUI() {
        this.makeFrameContent();
        String TITLE = "JASigning Video Generation Server (2022-06-26)";
        this.frame = new JFrame("JASigning Video Generation Server (2022-06-26)");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent wevt) {
                ServiceApp.this.doShutDown();
            }

            @Override
            public void windowClosed(WindowEvent wevt) {
                ServiceApp.this.doQuit();
            }
        });
        this.frame.setDefaultCloseOperation(3);
        this.frame.setContentPane(this.content);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    protected void makeFrameContent() {
        this.content = new JPanel(new BorderLayout());
        this.content.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.txtLog = new JTextArea(24, 80){

            @Override
            protected void paintComponent(Graphics g) {
                ((Graphics2D)g).setRenderingHints(AA_HINTS);
                super.paintComponent(g);
            }
        };
        this.txtLog.setFont(this.getLogFont());
        this.txtLog.setMargin(new Insets(4, 4, 4, 4));
        this.scrollLog = new JScrollPane(this.txtLog);
        final JCheckBox CHKVID = new JCheckBox("Video", true);
        CHKVID.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent cevt) {
                DO_VIDEO = CHKVID.isSelected();
            }
        });
        final JCheckBox CHKFRM = new JCheckBox("Frames", false);
        CHKFRM.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent cevt) {
                DO_FRAMES = CHKFRM.isSelected();
            }
        });
        final JCheckBox CHKLOG = new JCheckBox("Log", false);
        CHKLOG.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent cevt) {
                DO_LOGGING = CHKLOG.isSelected();
            }
        });
        JButton bttntest = new JButton("Test");
        bttntest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aevt) {
                ServiceApp.this.doRunTestClient();
            }
        });
        JButton bttnquit = new JButton("Quit");
        bttnquit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aevt) {
                ServiceApp.this.doShutDown();
                ServiceApp.this.doQuit();
            }
        });
        Box boxctrl = Box.createVerticalBox();
        boxctrl.setBorder(BorderFactory.createEtchedBorder());
        boxctrl.add(Box.createRigidArea(new Dimension(0, 4)));
        boxctrl.add(CHKVID);
        boxctrl.add(Box.createRigidArea(new Dimension(0, 4)));
        boxctrl.add(CHKFRM);
        boxctrl.add(Box.createRigidArea(new Dimension(0, 4)));
        boxctrl.add(CHKLOG);
        boxctrl.add(Box.createRigidArea(new Dimension(0, 4)));
        boxctrl.add(bttntest);
        boxctrl.add(Box.createRigidArea(new Dimension(0, 4)));
        boxctrl.add(bttnquit);
        boxctrl.add(Box.createRigidArea(new Dimension(0, 4)));
        boxctrl.add(Box.createVerticalGlue());
        Box boxhpad = Box.createHorizontalBox();
        boxhpad.add(Box.createRigidArea(new Dimension(4, 0)));
        boxhpad.add(boxctrl);
        this.content.add((Component)this.scrollLog, "Center");
        this.content.add((Component)boxhpad, "East");
    }

    static {
        AA_HINTS = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

