/*
 * Decompiled with CFR 0.152.
 */
package com.cwasa.javacv;

import com.cwasa.javacv.Logging;
import com.cwasa.javacv.ServiceApp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;

public class ClientForTesting
extends Thread {
    private final Logging LOG;
    private final int N_FRAMES;
    private final int W;
    private final int H;
    private final int FPS;
    private final String MOVIE_PATH;
    private OutputStream OUT_TO_SERVER;
    private final byte[] BUF;
    private int nWrite;
    private final int P_SIZE;
    private final byte[] BGR_BYTES;

    public static void startTest(int n, int w, int h, int fps, String moviepath, Logging thelog) {
        try {
            ClientForTesting cthread = new ClientForTesting(n, w, h, fps, moviepath, thelog);
            cthread.start();
        }
        catch (IOException iox) {
            thelog.log("Client ctor:" + iox);
        }
    }

    private ClientForTesting(int n, int w, int h, int fps, String moviepath, Logging thelog) throws IOException {
        this.LOG = thelog;
        this.LOG.log("ClientForTesting starts ...");
        this.N_FRAMES = n;
        this.W = w;
        this.H = h;
        this.FPS = fps;
        this.MOVIE_PATH = moviepath;
        this.P_SIZE = w * h;
        Socket sckt = new Socket("localhost", 41414);
        OutputStream couts = sckt.getOutputStream();
        this.OUT_TO_SERVER = new GZIPOutputStream(couts);
        this.BUF = new byte[4];
        this.BGR_BYTES = new byte[w * h * 3];
        this.nWrite = 0;
    }

    @Override
    public void run() {
        try {
            this.LOG.log("ClientForTesting.run() at " + new Date());
            long ta = System.nanoTime();
            this.writeInt(this.N_FRAMES);
            this.writeInt(this.W);
            this.writeInt(this.H);
            this.writeInt(this.FPS);
            this.writeString(this.MOVIE_PATH);
            this.LOG.log(String.format("Client: N=%d (W,H)=(%d,%d) FPS=%d  Video file: %s", this.N_FRAMES, this.W, this.H, this.FPS, this.MOVIE_PATH));
            int[] pixels = new int[this.P_SIZE];
            for (int f = 0; f != this.N_FRAMES; ++f) {
                long t0 = System.nanoTime();
                BufferedImage bimg = ClientForTesting.getImage(f);
                long t1 = System.nanoTime();
                bimg.getRGB(0, 0, this.W, this.H, pixels, 0, this.W);
                long t2 = System.nanoTime();
                this.writePixels(pixels);
                if (!ServiceApp.DO_LOGGING) continue;
                long t3 = System.nanoTime();
                int tr = (int)((t1 - t0) / 1000L);
                int tp = (int)((t2 - t1) / 1000L);
                int tw = (int)((t3 - t2) / 1000L);
                this.LOG.log(String.format("Client frame %d:  tR=%d  tP=%d  tW=%d", f, tr, tp, tw));
            }
            this.OUT_TO_SERVER.close();
            long tb = System.nanoTime();
            this.LOG.log("Client output: nWrite=" + this.nWrite);
            this.LOG.log("Client done: N_FRAMES=" + this.N_FRAMES);
            int tall = (int)((tb - ta) / 1000000L);
            this.LOG.log(String.format("Client total t=%d ms.", tall));
        }
        catch (IOException iox) {
            this.LOG.log("Client error:");
            for (StackTraceElement ste : iox.getStackTrace()) {
                this.LOG.log(ste.toString());
            }
        }
    }

    private void writePixels(int[] pixels) throws IOException {
        byte[] BGR = this.BGR_BYTES;
        int b = 0;
        for (int y = this.H; y != 0; --y) {
            int ROW_BASE = (y - 1) * this.W;
            for (int x = 0; x != this.W; ++x) {
                int val = pixels[ROW_BASE + x];
                BGR[b + 0] = (byte)val;
                BGR[b + 1] = (byte)(val >>= 8);
                BGR[b + 2] = (byte)(val >>= 8);
                val >>= 8;
                b += 3;
            }
        }
        this.OUT_TO_SERVER.write(BGR);
        this.nWrite += BGR.length;
    }

    private void writeString(String s) throws IOException {
        int N = s.length();
        this.writeInt(N);
        for (int i = 0; i != N; ++i) {
            this.writeInt(s.charAt(i) & 0xFFFF);
        }
    }

    private void writeInt(int val) throws IOException {
        int i = val;
        this.BUF[0] = (byte)i;
        this.BUF[1] = (byte)(i >>= 8);
        this.BUF[2] = (byte)(i >>= 8);
        this.BUF[3] = (byte)(i >>= 8);
        this.OUT_TO_SERVER.write(this.BUF);
        this.nWrite += 4;
    }

    protected static BufferedImage getImage(int f) throws IOException {
        return ImageIO.read(ClientForTesting.imageFile(f));
    }

    protected static File imageFile(int f) {
        return new File(ClientForTesting.imagePath(f));
    }

    protected static String imagePath(int f) {
        String F_TAG = String.format("%03d", f);
        return "frames/GRAB_" + F_TAG + ".png";
    }
}

