/*
 * OutermostAppletFinder.java		2008-06-18
 */
package app.util;

import java.applet.Applet;

import java.util.Enumeration;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;



/** This class embodies a crude hack, which attempts to identify
 * the parent JNLPAppletLauncher instance for a given applet.
 * This parent applet is needed when calling JSObject.getWindow()
 * under Firefox on Mac OS X; for some reason, other browser/platform
 * combinations seem to cope with the child applet, although strictly
 * speaking it is not one of the HTML page's applets.
 */
public class OutermostAppletFinder {

	public static final String	OAF_PREFIX = "####  OutermostAppletFinder: ";

	public static final String	LAUNCHER_NAME = "JNLPAppletLauncher";
	public static final String	LAUNCHER_SUFFIX = "AppletLauncher";
	public static final String	GET_SA_METHOD_NAME = "getSubApplet";

/** Searches the HTML applets of the given applet, i.e. those in its applet
 * context, and tries to find the one which either <em>is</em> the given
 * applet or is a JNLPAppletLauncher instance that has the given one as
 * its subapplet: returns this "outermost" applet if found, or
 * {@code null} otherwise.
 */
	public static Applet getOutermost(Applet applet) {

		Enumeration<Applet> htmlapplets =
			applet.getAppletContext().getApplets();

		int n = 0;	// counts the HTML applets;
		Applet outermost = null;	// the search result;
		while (outermost == null && htmlapplets.hasMoreElements()) {

			++ n;
			Applet htmlapplet = htmlapplets.nextElement();
			if (htmlapplet == applet) {

				outermost = htmlapplet;
				System.out.println(OAF_PREFIX+"given applet is outermost.");
			}
			else {
				final Class HA_CLASS = htmlapplet.getClass();
				final String HA_NAME = HA_CLASS.getName();

//				if (HA_NAME.endsWith(LAUNCHER_NAME)) {
				if (HA_NAME.endsWith(LAUNCHER_SUFFIX)) {

					try {
						Method getsa = HA_CLASS.getMethod(GET_SA_METHOD_NAME);
						Object subapplet = getsa.invoke(htmlapplet);

						if (subapplet == applet) {

							outermost = (Applet) htmlapplet;
							System.out.println(
								OAF_PREFIX+"given applet is subapplet of "+
								HA_NAME+".");
						}
					}
					catch (NoSuchMethodException nsmx) {
						System.out.println(nsmx);
					}
					catch (IllegalAccessException iax) {
						System.out.println(iax);
					}
					catch (InvocationTargetException itx) {
						System.out.println(itx);
					}
					catch (NullPointerException npx) {
						System.out.println(npx);
					}
				}
			}
		}

		// We hope we never fail to find the required applet, but if
		// we do fail we log the failure here.
		if (outermost == null) {
			System.out.println(
				OAF_PREFIX+"tried "+n+" HTML applet(s) -- all failed.");
		}

		return outermost;
	}
}
