/*
 * JACASSiGMLDemoApplet.java		2005-06-01
 */
package app;


import java.applet.Applet;

import java.util.Date;

import java.awt.Dimension;
import java.awt.BorderLayout;

import javax.swing.UIManager;

import jautil.JAOptions;
import jautil.JAEnv;
import static jautil.JARemote.FORCE_REMOTE_JA_HOME_KEY;
import static jautil.install.DeploymentParameters.JA_VERSION_TAG_KEY;
import static jautil.install.DeploymentParameters.JA_REMOTE_BASE_KEY;

import gui.JAFilePlayerPanel;

import app.util.AppletPropertiesCopier;


/** The original CAS/SiGML file-player demo applet. */
public class JACASSiGMLDemoApplet extends Applet {

	protected JAOptions							JA_OPTIONS;
	protected JAFilePlayerPanel					jaPlayerPanel;

	public JACASSiGMLDemoApplet() {
		super();
	}

	/** Initialises the applet, by creating its GUI panel. */
	public synchronized void init() {

		String jrevn = System.getProperty("java.version");
		System.out.println((new Date())+"   Java version "+jrevn);
		System.out.println("####  JA-CAS-SiGML-Demo Applet  ####");

		// Copy appropriate HTML parameter settings to the system properties.
		final String[] SYS_PROP_KEYS = {
			JA_VERSION_TAG_KEY,
			JA_REMOTE_BASE_KEY,
			FORCE_REMOTE_JA_HOME_KEY
		};
		AppletPropertiesCopier.copyAppletProperties(this, SYS_PROP_KEYS);

		// Set up JA options and environment for this execution of the applet.
		this.JA_OPTIONS =
			JAOptions.makeJAOptions(
				"JACASSiGMLDemoApplet", null, this,
				JAEnv.makeAppletJAEnv(this.getCodeBase()));

		// Set prefix for messages.
		String prefix =
			"####  JA-CAS-SiGML-Demo Applet"+
			(this.JA_OPTIONS.doForceAWT() ? " (AWT): " : ": ");

		// Create the GUI
		this.startGUI();
		System.out.println(prefix+"GUI created.");

		// Load avatar and SiGMLInLib
		this.jaPlayerPanel.completePlayerSetUp();
	}

	/** Starts the applet. */
	public synchronized void start() {
	}

	/** Stops this applet, i.e. stops any current animation. */
	public synchronized void stop() {

		this.jaPlayerPanel.stopPlayer();
	}

	/** Destroys this applet, disposing of all its JA and GL resources. */
	public synchronized void destroy() {

		try {
			this.jaPlayerPanel.terminate(null);
			System.out.println(
				"####  JA-CAS-SiGML-Demo-Applet: destroy() done.");
		}
		catch (Exception x) {
			System.out.println(
				"####  JA-CAS-SiGML-Demo-Applet: destroy() ...");
			x.printStackTrace(System.out);
		}
	}

	protected void startGUI() {

		// Get applet width and height.
		int w = this.getWidth();
		int h = this.getHeight();

		if (! this.JA_OPTIONS.doForceAWT()) {
			// Use the platform look-and-feel.
			String syslaf = UIManager.getSystemLookAndFeelClassName();
			try {
				UIManager.setLookAndFeel(syslaf);
			}
			catch (Exception xx) {
				System.out.println(
					"####  JA-CAS-SiGML-Demo-Applet set-up: "+xx);
			}
		}

		// Create our main panel and attach it to this applet.
		Dimension sz = new Dimension(w, h);
		this.jaPlayerPanel = new JAFilePlayerPanel(this.JA_OPTIONS);
		this.jaPlayerPanel.setPreferredSize(new Dimension(w, h));
		this.setLayout(new BorderLayout());
		this.add(this.jaPlayerPanel, BorderLayout.CENTER);
		this.validate();
	}

	public static void reportPaths() {

		String upath = System.getProperty("user.dir");
		System.out.println("U-DIR-PATH:  "+upath+";");
		String cpath = System.getProperty("java.class.path");
		System.out.println("CLASS-PATH:  "+cpath+";");
		String lpath = System.getProperty("java.library.path");
		System.out.println("LIB-PATH  :  "+lpath+";");
	}
}
