/*
 * AppletPropertiesCopier		2008-06-23
 */
package app.util;


import java.applet.Applet;


/** Provides static methods to copy specified applet parameter settings
 * to the system properties.
 */
public class AppletPropertiesCopier {

/** Copies all applet parameter settings whose names appear in the given
 * list of property names to the system properties.
 */
	public static final void copyAppletProperties(
		Applet applet, String[] propnames) {

		for (String pname : propnames)
			copyAppletProperty(applet, pname);
	}

/** Checks whether the given applet has a parameter with the given
 * property name and if so sets the system property of that name to
 * the given parameter value. */
	public static final void copyAppletProperty(
		Applet applet, String propname) {

		final String PROP_VAL = applet.getParameter(propname);
		if (PROP_VAL != null)
			System.setProperty(propname, PROP_VAL);
	}
}
