/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package signstreamer;

import java.io.File;
import java.io.FileReader;

/*
 * SignStreamer.java
 *
 * Created on August 2, 2002, 5:38 AM
 * 
 * (c) UEA, Norwich, UK
 */

/**
 *
 * @author  Robert Smith, UEA (a165905)
 */

public class SignStreamer extends javax.swing.JFrame {
    
    private File file;
    private FileReader file_reader;
    private FileStreamer file_streamer;
    
    /** Creates new form SignStreamer */
    public SignStreamer() {
        initComponents();
        this.setSize(600, 300);
        this.setResizable(false);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        sign_chooser = new javax.swing.JFileChooser();
        file_label = new javax.swing.JLabel();
        file_button = new javax.swing.JButton();
        host_label = new javax.swing.JLabel();
        host_txt = new javax.swing.JTextField();
        port_label = new javax.swing.JLabel();
        port_txt = new javax.swing.JTextField();
        send_button = new javax.swing.JButton();

        sign_chooser.setCurrentDirectory(new java.io.File("/rspc/home/a165905/."));
        sign_chooser.setDialogTitle("Select Sign File");
        sign_chooser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sign_chooserActionPerformed(evt);
            }
        });

        getContentPane().setLayout(new java.awt.GridLayout(0, 1));

        setTitle("SignSender");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        file_label.setText("File:");
        getContentPane().add(file_label);

        file_button.setText("Select File");
        file_button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                file_buttonActionPerformed(evt);
            }
        });

        getContentPane().add(file_button);

        host_label.setText("Host:");
        getContentPane().add(host_label);

        host_txt.setText("localhost");
        getContentPane().add(host_txt);

        port_label.setText("Port:");
        getContentPane().add(port_label);

        // SiGML port: 8052
        port_txt.setText("8052");
        getContentPane().add(port_txt);

        send_button.setText("Send File");
        send_button.setEnabled(false);
        send_button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                send_buttonActionPerformed(evt);
            }
        });

        getContentPane().add(send_button);

        pack();
    }//GEN-END:initComponents

    private void send_buttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_send_buttonActionPerformed
        FileStreamer.stream(file, host_txt.getText(), Integer.parseInt(port_txt.getText()));
    }//GEN-LAST:event_send_buttonActionPerformed

    private void file_buttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_file_buttonActionPerformed
        int opened = sign_chooser.showOpenDialog(this);
        System.out.println(opened);
        if (opened == 0) {
            file = sign_chooser.getSelectedFile();
            file_label.setText("File:" + file.toString());
            send_button.setEnabled(true);
        }
    }//GEN-LAST:event_file_buttonActionPerformed

    private void sign_chooserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sign_chooserActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_sign_chooserActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new SignStreamer().show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFileChooser sign_chooser;
    private javax.swing.JLabel port_label;
    private javax.swing.JTextField port_txt;
    private javax.swing.JLabel file_label;
    private javax.swing.JLabel host_label;
    private javax.swing.JTextField host_txt;
    private javax.swing.JButton file_button;
    private javax.swing.JButton send_button;
    // End of variables declaration//GEN-END:variables
    
}
