/*
 * Decompiled with CFR 0.152.
 */
package signstreamer;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import signstreamer.FileStreamer;

public class SignStreamer
extends JFrame {
    private File file;
    private FileReader file_reader;
    private FileStreamer file_streamer;
    private JFileChooser sign_chooser;
    private JLabel port_label;
    private JTextField port_txt;
    private JLabel file_label;
    private JLabel host_label;
    private JTextField host_txt;
    private JButton file_button;
    private JButton send_button;

    public SignStreamer() {
        this.initComponents();
        this.setSize(600, 300);
        this.setResizable(false);
    }

    private void initComponents() {
        this.sign_chooser = new JFileChooser();
        this.file_label = new JLabel();
        this.file_button = new JButton();
        this.host_label = new JLabel();
        this.host_txt = new JTextField();
        this.port_label = new JLabel();
        this.port_txt = new JTextField();
        this.send_button = new JButton();
        this.sign_chooser.setCurrentDirectory(new File("/rspc/home/a165905/."));
        this.sign_chooser.setDialogTitle("Select Sign File");
        this.sign_chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignStreamer.this.sign_chooserActionPerformed(evt);
            }
        });
        this.getContentPane().setLayout(new GridLayout(0, 1));
        this.setTitle("SignSender");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SignStreamer.this.exitForm(evt);
            }
        });
        this.file_label.setText("File:");
        this.getContentPane().add(this.file_label);
        this.file_button.setText("Select File");
        this.file_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignStreamer.this.file_buttonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.file_button);
        this.host_label.setText("Host:");
        this.getContentPane().add(this.host_label);
        this.host_txt.setText("localhost");
        this.getContentPane().add(this.host_txt);
        this.port_label.setText("Port:");
        this.getContentPane().add(this.port_label);
        this.port_txt.setText("8052");
        this.getContentPane().add(this.port_txt);
        this.send_button.setText("Send File");
        this.send_button.setEnabled(false);
        this.send_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignStreamer.this.send_buttonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.send_button);
        this.pack();
    }

    private void send_buttonActionPerformed(ActionEvent evt) {
        FileStreamer.stream(this.file, this.host_txt.getText(), Integer.parseInt(this.port_txt.getText()));
    }

    private void file_buttonActionPerformed(ActionEvent evt) {
        int opened = this.sign_chooser.showOpenDialog(this);
        System.out.println(opened);
        if (opened == 0) {
            this.file = this.sign_chooser.getSelectedFile();
            this.file_label.setText("File:" + this.file.toString());
            this.send_button.setEnabled(true);
        }
    }

    private void sign_chooserActionPerformed(ActionEvent evt) {
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new SignStreamer().show();
    }
}

