#!/usr/bin/env  csh

cd `dirname $0`

set XU_JARS="$XUGGLE_HOME/share/java/jars"
set XU_MAIN_JAR="$XU_JARS/xuggle-xuggler.jar"

if ! (-e frames && -d frames) then
    echo "WARNING: we need the frames/ directory for testing."
endif

set JAVACMD = java

echo "Running JASigning Video Generation Server"
echo "pwd:  `pwd`"

$JAVACMD -d64 -Xms64m -cp javidgen.jar:$XU_MAIN_JAR javidgen.ServiceApp

echo "Done JASigning Video Generation Server"

exit
# (END)
set JVERTEST = `$JAVACMD -version |& grep 'version.*1\.6'`

# Check that we have Java 6, and try remedial action if not.
if ("$JVERTEST" !~ "*1.6*") then

	set JVDIR = "/System/Library/Frameworks/JavaVM.framework/Versions"
	set J6CMD = "$JVDIR/1.6/Home/bin/java"

	if ( !( -e $J6CMD) ) then
		echo "Unable to find a Java 6 Runtime on this Mac, which"
		echo "is needed for video generation -- command aborted."
		exit 1
	endif

	set JAVACMD = $J6CMD
endif
