/*
 * Decompiled with CFR 0.152.
 */
package javidgen;

import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.IRational;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javidgen.FrameQueue;
import javidgen.Logging;
import javidgen.ServiceApp;

public class VideoMaker {
    public static final String VM_TAG = "VideoMaker/Consumer";
    private final int W;
    private final int H;
    private final int FPS;
    private final Logging LOG;
    private final String DOT_MOV_PATH;
    private final FrameQueue FRAME_QUEUE;

    private void log(String msg) {
        this.LOG.log(msg);
    }

    private void logt(String msg) {
        this.log(VM_TAG + msg);
    }

    private void logc(String msg) {
        if (ServiceApp.DO_LOGGING) {
            this.log(msg);
        }
    }

    private void logct(String msg) {
        if (ServiceApp.DO_LOGGING) {
            this.logt(msg);
        }
    }

    public VideoMaker(int w, int h, int fps, String mpath, FrameQueue fq, Logging log) {
        this.LOG = log;
        this.W = w;
        this.H = h;
        this.FPS = fps;
        this.DOT_MOV_PATH = mpath;
        this.FRAME_QUEUE = fq;
        this.makeVideoFile();
    }

    protected void makeVideoFile() {
        try {
            IMediaWriter moviewrtr = ServiceApp.DO_VIDEO ? ToolFactory.makeWriter((String)this.DOT_MOV_PATH) : null;
            IRational FPS_IR = IRational.make((int)this.FPS, (int)1);
            if (ServiceApp.DO_VIDEO) {
                moviewrtr.addVideoStream(0, 0, FPS_IR, this.W, this.H);
            }
            this.logt(" starts.");
            int f = 0;
            byte[] fpixels = this.FRAME_QUEUE.getNextFrame();
            while (fpixels != null) {
                long t0 = System.nanoTime();
                BufferedImage FRAME = this.makeImage(fpixels);
                long T_MS = (long)((double)(1000 * f) / (double)this.FPS);
                if (ServiceApp.DO_VIDEO) {
                    moviewrtr.encodeVideo(0, FRAME, T_MS, TimeUnit.MILLISECONDS);
                }
                if (ServiceApp.DO_FRAMES) {
                    VideoMaker.putImage(this.DOT_MOV_PATH + ".frames", f, FRAME);
                }
                this.FRAME_QUEUE.freeItem(fpixels);
                long t1 = System.nanoTime();
                int tgen = (int)((t1 - t0) / 1000L);
                this.logct(String.format(" frame %d:  t-gen=%d", f, tgen));
                fpixels = this.FRAME_QUEUE.getNextFrame();
                ++f;
            }
            if (ServiceApp.DO_VIDEO) {
                moviewrtr.close();
            }
            if (ServiceApp.DO_FRAMES) {
                Properties props = new Properties();
                props.setProperty("Path", this.DOT_MOV_PATH);
                props.setProperty("FrameCount", "" + f);
                props.setProperty("Width", "" + this.W);
                props.setProperty("Height", "" + this.H);
                props.setProperty("FPS", "" + this.FPS);
                File pFil = new File(this.DOT_MOV_PATH + ".frames/Attributes.properties");
                FileOutputStream oFil = new FileOutputStream(pFil);
                props.store(oFil, "Video Generator Settings");
                pFil = new File(this.DOT_MOV_PATH + ".frames/Attributes.xml");
                oFil = new FileOutputStream(pFil);
                props.storeToXML(oFil, "Video Generator Settings");
            }
            this.logt(" done: N=" + f);
        }
        catch (Throwable t) {
            this.logt(" failure:");
            for (StackTraceElement ste : t.getStackTrace()) {
                this.log(ste.toString());
            }
        }
    }

    private BufferedImage makeImage(byte[] pixels) throws IOException {
        BufferedImage bimg = new BufferedImage(this.W, this.H, 5);
        byte[] imgbytes = ((DataBufferByte)bimg.getRaster().getDataBuffer()).getData();
        int ROW_SZ = this.W * 3;
        int TOTAL_SZ = this.H * ROW_SZ;
        int LAST_ROW_IX = TOTAL_SZ - ROW_SZ;
        for (int y = 0; y != this.H; ++y) {
            int P_BASE = y * ROW_SZ;
            int IMG_BASE = LAST_ROW_IX - P_BASE;
            System.arraycopy(pixels, P_BASE, imgbytes, IMG_BASE, ROW_SZ);
        }
        return bimg;
    }

    protected static void putImage(String DIR, int f, BufferedImage bimg) throws IOException {
        ImageIO.write((RenderedImage)bimg, "png", VideoMaker.imageFile(DIR, f));
    }

    protected static File imageFile(String DIR, int f) {
        File FIL = new File(VideoMaker.imagePath(DIR, f));
        if (f == 0) {
            FIL.mkdirs();
        }
        return FIL;
    }

    protected static String imagePath(String DIR, int f) {
        String F_TAG = String.format("%05d", f);
        return DIR + "/Frame" + F_TAG + ".png";
    }
}

