/*
 * Decompiled with CFR 0.152.
 */
package javidgen;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javidgen.Logging;

public class JAVideoServiceThread
extends Thread {
    public static final int VIDEO_SERVICE_PORT = 41414;
    public static final int VIDEO_SERVICE_CHECK_PORT = 41415;
    public static final String VST_TAG = "JA Video Service Thread";
    private final Logging LOG;
    private final ServerSocket SERVICE_SOCKET;
    private final VideoRequestHandler REQUEST_HANDLER;

    private void log(String msg) {
        this.LOG.log(msg);
    }

    private void logt(String msg) {
        this.log(VST_TAG + msg);
    }

    public JAVideoServiceThread(VideoRequestHandler vrh, Logging log) throws IOException {
        this.LOG = log;
        this.SERVICE_SOCKET = new ServerSocket(41414);
        this.REQUEST_HANDLER = vrh;
    }

    public void shutDown() throws IOException {
        this.SERVICE_SOCKET.close();
    }

    @Override
    public void run() {
        this.logt(" starts.");
        try {
            while (true) {
                Socket ccsckt = this.SERVICE_SOCKET.accept();
                this.logt(": request accepted.");
                if (!this.isValid(ccsckt)) continue;
                this.REQUEST_HANDLER.processRequest(ccsckt);
            }
        }
        catch (IOException iox) {
            this.logt(": " + iox);
            this.logt(" done.");
            System.out.println("JA Video Service Thread done.");
            return;
        }
    }

    private boolean isValid(Socket ccsckt) {
        boolean ok = false;
        try {
            JAVideoServiceThread.checkLocal(ccsckt);
            ok = true;
        }
        catch (IOException iox) {
            this.logt(" request check fails: " + iox);
        }
        return ok;
    }

    public static void checkLocal(Socket ccsckt) throws IOException {
        InetAddress localaddr;
        boolean ok;
        InetAddress clientaddr = ccsckt.getInetAddress();
        boolean bl = ok = clientaddr.equals(localaddr = InetAddress.getLocalHost()) || clientaddr.getHostAddress().equals("127.0.0.1");
        if (!ok) {
            throw new IOException("Non-local client: " + clientaddr);
        }
    }

    public static interface VideoRequestHandler {
        public void processRequest(Socket var1);
    }
}

