/*
 * Decompiled with CFR 0.152.
 */
package javidgen;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javidgen.JAVideoServiceThread;
import javidgen.Logging;

public class JAVideoServiceCheckThread
extends Thread {
    public static final String VSCT_TAG = "JA Video Service Check Thread";
    private final Logging LOG;
    private final ServerSocket CHECK_SOCKET;

    private void log(String msg) {
        this.LOG.log(msg);
    }

    private void logt(String msg) {
        this.log(VSCT_TAG + msg);
    }

    public JAVideoServiceCheckThread(Logging log) throws IOException {
        this.LOG = log;
        this.CHECK_SOCKET = new ServerSocket(41415, 1);
    }

    public void shutDown() throws IOException {
        this.CHECK_SOCKET.close();
    }

    @Override
    public void run() {
        this.logt(" starts.");
        try {
            while (true) {
                Socket ccsckt = this.CHECK_SOCKET.accept();
                this.logt(": check received.");
                if (this.isValid(ccsckt)) continue;
                Thread.sleep(500L);
            }
        }
        catch (IOException iox) {
            this.logt(": " + iox);
        }
        catch (InterruptedException ix) {
            this.logt(": " + ix);
            Thread.currentThread().interrupt();
        }
        this.logt(" done.");
    }

    private boolean isValid(Socket ccsckt) {
        boolean ok = false;
        try {
            JAVideoServiceThread.checkLocal(ccsckt);
            ok = true;
        }
        catch (IOException iox) {
            this.logt(" check validation fails: " + iox);
        }
        return ok;
    }
}

