/*
 * Decompiled with CFR 0.152.
 */
package javidgen;

import java.util.concurrent.LinkedBlockingQueue;

public class FrameQueue {
    private static final int STD_CAPACITY = 16;
    private final int FRAME_SIZE;
    private final int CAPACITY;
    private final LinkedBlockingQueue<byte[]> PIXEL_DATA_QUEUE;
    private final LinkedBlockingQueue<byte[]> FREE_QUEUE;
    private final byte[] Q_TERMINATOR;
    private boolean queueIsClosed;

    public FrameQueue(int fsz) {
        this(fsz, 16);
    }

    public FrameQueue(int fsz, int cpcty) {
        this.FRAME_SIZE = fsz;
        this.CAPACITY = cpcty;
        this.FREE_QUEUE = new LinkedBlockingQueue();
        this.PIXEL_DATA_QUEUE = 0 < this.CAPACITY ? new LinkedBlockingQueue(this.CAPACITY) : new LinkedBlockingQueue();
        this.Q_TERMINATOR = new byte[0];
        this.queueIsClosed = false;
    }

    public byte[] allocItem() {
        byte[] item = this.FREE_QUEUE.poll();
        if (item == null) {
            item = new byte[this.FRAME_SIZE];
        }
        return item;
    }

    public void freeItem(byte[] item) throws InterruptedException {
        this.FREE_QUEUE.put(item);
    }

    public void addFrame(byte[] fpixels) throws InterruptedException {
        if (!this.queueIsClosed) {
            this.PIXEL_DATA_QUEUE.put(fpixels);
        } else {
            System.out.println("FrameQueue: ignore addFrame() after queue is closed.");
        }
    }

    public void closeQueue() throws InterruptedException {
        this.addFrame(this.Q_TERMINATOR);
        this.queueIsClosed = true;
    }

    public byte[] getNextFrame() throws InterruptedException {
        byte[] fpixels = null;
        byte[] PIXELS = this.PIXEL_DATA_QUEUE.take();
        if (PIXELS != this.Q_TERMINATOR) {
            fpixels = PIXELS;
        }
        return fpixels;
    }
}

