/*
 * SToC.java		2011-11-30
 */
package app.util;


import jautil.JATimer;
import java.io.StringReader;
import java.io.StringWriter;


import jautil.JAOptions;

import casxml.CASWriter;

import sigmlanim.AnimatedSign;
import sigmlanim.SiGMLAnimation;
import sigmlanim.StreamedAnimationLoader;

import player.SignsArrayAccess;

import static app.SToCApplet.SToCALogger;

/** SiGML-to-CAS converter for the {@link app.SToCApplet}.
 */
public class SToC {

	private static final String				STOC_PFX = "SToC: ";
/** Options settings. */
	private final JAOptions					JA_OPTS;
/** Logger */
	private final SToCALogger				LOGGER;


	public SToC(JAOptions jaopts, SToCALogger logger) {

		this.JA_OPTS = jaopts;
		this.LOGGER = logger;
	}

	public String sigmlURLToCAS(String sigmlurl, String avatar) {

		String cas = null;
		SiGMLAnimation sa = this.sigmlURLToAnim(sigmlurl, avatar);
		cas = this.animToCASString(avatar, sa);
		if (cas != null) { this.log("CAS length="+cas.length()); }
		else { this.log("CAS gen failed."); }

		return cas;
	}

	public String sigmlTextToCAS(String sigml, String avatar) {

		String cas = null;
		SiGMLAnimation sa = this.sigmlToAnim(sigml, avatar);
		cas = this.animToCASString(avatar, sa);
		if (cas != null) { this.log("CAS length="+cas.length()); }
		else { this.log("CAS gen failed."); }

		return cas;
	}

	protected SiGMLAnimation sigmlToAnim(String sigml, String avatar) {

		final StringReader SIGML_RDR = new StringReader(sigml);
		final StreamedAnimationLoader SA_LOADER =
			new StreamedAnimationLoader(avatar, this.JA_OPTS, SIGML_RDR, null);
		JATimer tmr = new JATimer();
		SA_LOADER.processSiGML();

		final SiGMLAnimation ANIM = SA_LOADER.getAnimation();

		final SignsArrayAccess SIGNS = ANIM.getSignsArray();

		// NB If something odd happens, this loop might become eternal.
		while (!SIGNS.arrayIsFinal()) {
			//try { SIGNS.waitForProgress(); }
			try {
				SIGNS.waitForProgress();
				tmr.showTimeMS(
					"ns="+SIGNS.countSigns()+
					(SIGNS.arrayIsFinal()?" DONE":"")+" t=");
			}
			catch (InterruptedException ix) {
				this.log("SToC.sigmlToAnim(): "+ix);
			}
		}

		return ANIM;
	}

	protected SiGMLAnimation sigmlURLToAnim(String sigmlurl, String avatar) {

		final StreamedAnimationLoader SA_LOADER =
			new StreamedAnimationLoader(avatar, this.JA_OPTS, sigmlurl, null);
		JATimer tmr = new JATimer();
		SA_LOADER.processSiGML();

		final SiGMLAnimation ANIM = SA_LOADER.getAnimation();

		final SignsArrayAccess SIGNS = ANIM.getSignsArray();

		// NB If something odd happens, this loop might become eternal.
		while (!SIGNS.arrayIsFinal()) {
			//try { SIGNS.waitForProgress(); }
			try {
				SIGNS.waitForProgress();
				tmr.showTimeMS(
					"ns="+SIGNS.countSigns()+
					(SIGNS.arrayIsFinal()?" DONE":"")+" t=");
			}
			catch (InterruptedException ix) {
				this.log("SToC.sigmlURLToAnim(): "+ix);
			}
		}

		return ANIM;
	}

/** Generates a CAS string for the given animation.
 */
	protected String animToCASString(String av, SiGMLAnimation anim) {

		String cas = null;
		JATimer tmr = new JATimer();

		final String MSG_PFX = "SToC.animToCASString(): ";
		try {
			StringWriter caswrtr = new StringWriter(16384);

			final AnimatedSign[] SIGNS =  anim.getSignsArray().signs();
			CASWriter.writeDocument(caswrtr, av, SIGNS);
			this.log("CAS string generated.");
			cas = caswrtr.toString();
			tmr.showTimeMS("CAS-gen  t=");
		}
		catch (CASWriter.CASWriterException cwx) { this.log(MSG_PFX+cwx); }

		return cas;
	}

	private final void log(String msg) { this.LOGGER.log(msg); }
	private final void logp(String msg) { this.logb(STOC_PFX+msg); }
	private final void logb(String msg) { this.LOGGER.logb(STOC_PFX+msg); }
}
