/*
 * JACASSiGMLDemo.java
 *
 * JARP  2005-05-31
 */
package app;


import java.util.Date;


import java.lang.reflect.InvocationTargetException;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.UIManager;


import jautil.JAOptions;
import jautil.JAEnv;

import gui.JAFilePlayerPanel;


/** The original CAS/SiGML file-player demo app. */
public class JACASSiGMLDemo {

	/** main() method -- creates an instance of the app. */
	public static void main(String[] args)
		throws InterruptedException, InvocationTargetException {

		String jrevn = System.getProperty("java.version");
		System.out.println(
			(new Date())+"   Java version "+jrevn+"   JA CAS-SiGML Demo");

		JACASSiGMLDemo jdapp = new JACASSiGMLDemo(args);
	}

	/*##########  Instance Variables  ##########*/

	protected JAOptions						jarpOptions;

	protected Frame							jarpWin;

	protected JAFilePlayerPanel				jarpPanel;

	/** Sets up the GUI, which is then ready to field
	 * CAS/SiGML-Load and Play requests.
	 */
	public JACASSiGMLDemo(String[] args)
	throws InterruptedException, InvocationTargetException {

		// Get JA options and environment for this execution of the app.
		this.jarpOptions =
			JAOptions.makeJAOptions(
				"JACASSiGMLDemo", args, JAEnv.makeAppJAEnv());

		// Trigger the set-up of our GUI (from the Java GUI thread).
		final Runnable RUNNABLE_START_GUI =
			new Runnable() {
				public void run() {
					JACASSiGMLDemo.this.startGUI();
				}
			};
		EventQueue.invokeAndWait(RUNNABLE_START_GUI);
		System.out.println("####  JA-CAS-SiGML--Demo:  GUI set-up done.");

		this.jarpPanel.completePlayerSetUp();
	}

	/** Creates and initially displays the GUI for this Java ARP test app.
	 * This method should be invoked on the AWT-event thread.
	 */
	protected void startGUI() {

		// Define AWT/non-AWT tag for message strings.
		String modetag = (this.jarpOptions.doForceAWT() ? " (AWT)" : "");

		// Use the platform look-and-feel.
		String syslaf = UIManager.getSystemLookAndFeelClassName();
		try {
			UIManager.setLookAndFeel(syslaf);
		}
		catch (Exception xx) {
			String prefix = "####  JA-CAS-SiGML-Demo"+modetag+" startGUI(): ";
			System.out.println(prefix+xx.getMessage());
		}

		// Create a frame window, using the AWT Frame class,
		// for JOGL canvas's sake.
		this.jarpWin = new Frame("JA CAS/SiGML Demo"+modetag);

		// Get current user preferences for window size and location.
		int[] xywh = this.jarpOptions.appWindowLocationAndSize();
		int xwin = xywh[0];
		int ywin = xywh[1];
		int width = xywh[2];
		int height = xywh[3];

		// Create our main panel and attach it to our frame window.
		this.jarpPanel = new JAFilePlayerPanel(this.jarpOptions);
		this.jarpPanel.setPreferredSize(new Dimension(width, height));
		this.jarpWin.add(this.jarpPanel);

		// Arrange to treat app window's close-event as a quit trigger.
		this.setQuitAction();

		// Now make the window visible.
		this.jarpWin.setLocation (xwin, ywin);
		this.jarpWin.pack();
		this.jarpWin.setVisible(true);
		System.out.println(
			"####  JA-CAS-SiGML-Demo"+modetag+":  app window now displayed.");
	}

	/** Attaches a suitable close-event handler
	 * (which terminates the JARP view panel and quits) to the app window.
	 */
	protected void setQuitAction() {

		this.jarpWin.addWindowListener(

			new WindowAdapter() {

				public void windowClosing(WindowEvent we) {
					// Run this on another thread than the AWT event
					// queue to ensure that JARP display shut-down
					// completes before we exit.
					final Thread QUIT_THREAD =
						new Thread() {
							public void run() {
								JACASSiGMLDemo.this.windowClosingHandler();
								System.exit(0);
							}
						};
					QUIT_THREAD.start();
				}
			}
		);
	}

	/** Handler for the window-closing event: stops the player,
	 * flushes window-size and camera-settings preferences,
	 * and kills the JA panel/player.
	 */
	protected void windowClosingHandler() {

		try {
			this.jarpPanel.terminate(this.jarpWin.getLocation());
		}
		catch (InterruptedException ix) {
			System.out.println(
				"####  JA-CAS-SiGML-Demo:  window close interrupted:"+ix);
		}
	}
}
