<xsl:transform version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- NB  THIS IS CURRENTLY AN UNAMBIGUOUSLY CHEAP-AND-CHEERFUL, -->
<!-- I.E. INCOMPLETE, VERSION OF THE REQUIRED TRANSFORM.  IN    -->
<!-- PARTICULAR, IT DOES NOT SUPPORT SEQUENTIAL OR PARALLEL     -->
<!-- COMPOSITION OF BASIC ELEMENTS OF A GIVEN KIND, NOR THE     -->
<!-- SYNCHRONIZATION ATTRIBUTES.    2001-12-08                  -->

<!-- ALLOWS hnm_extra ELEMENTS.     2003-10-02                  -->


<!--######## hamnosys_nonmanual ########-->
<!--====================================-->
<xsl:template match="hamnosys_nonmanual">
    <!--
    <!ELEMENT hamnosys_nonmanual (
        ( hnm_shoulder
        | hnm_body
        | hnm_head
        | hnm_eyegaze
        | hnm_eyebrows
        | hnm_eyelids
        | hnm_nose
        | hnm_mouthgesture
        | hnm_mouthpicture
        | hns_extra )+
    )>
    -->

    <xsl:element name="sign_nonmanual">

        <xsl:if test="hnm_shoulder">
            <xsl:element name="shoulder_tier">
                <xsl:choose>
                    <xsl:when test="count(hnm_shoulder)=1">
                        <xsl:apply-templates select="hnm_shoulder"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="shoulder_par">
                            <xsl:apply-templates select="hnm_shoulder"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>


        <xsl:if test="hnm_body">
            <xsl:element name="body_tier">
                <xsl:choose>
                    <xsl:when test="count(hnm_body)=1">
                        <xsl:apply-templates select="hnm_body"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="body_par">
                            <xsl:apply-templates select="hnm_body"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>

        <xsl:if test="hnm_head">
            <xsl:element name="head_tier">
                <xsl:choose>
                    <xsl:when test="count(hnm_head)=1">
                        <xsl:apply-templates select="hnm_head"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="head_par">
                            <xsl:apply-templates select="hnm_head"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>

        <xsl:if test="hnm_eyegaze">
            <xsl:element name="eyegaze_tier">
                <xsl:choose>
                    <xsl:when test="count(hnm_eyegaze)=1">
                        <xsl:apply-templates select="hnm_eyegaze"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="eye_par">
                            <xsl:apply-templates select="hnm_eyegaze"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>

        <xsl:if test="hnm_eyebrows | hnm_eyelids | hnm_nose">
            <xsl:element name="facialexpr_tier">
                <xsl:choose>
                    <xsl:when test=
                      "count(hnm_eyebrows | hnm_eyelids | hnm_nose)=1">
                        <xsl:apply-templates
                            select=
                            "hnm_eyebrows | hnm_eyelids | hnm_nose"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="facial_expr_par">
                            <xsl:apply-templates
                                select=
                                "hnm_eyebrows | hnm_eyelids | hnm_nose"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>

        <xsl:if test="hnm_mouthgesture | hnm_mouthpicture">
            <xsl:element name="mouthing_tier">
                <xsl:choose>
                    <xsl:when test=
                      "count(hnm_mouthgesture | hnm_mouthpicture)=1">
                        <xsl:apply-templates
                            select=
                            "hnm_mouthgesture | hnm_mouthpicture"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="mouthing_par">
                            <xsl:apply-templates
                                select=
                                "hnm_mouthgesture | hnm_mouthpicture"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>


        <xsl:if test="hnm_extra">
            <xsl:element name="extra_tier">
                <xsl:choose>
                    <xsl:when test="count(hnm_extra)=1">
                        <xsl:apply-templates select="hnm_extra"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="extra_par">
                            <xsl:apply-templates select="hnm_extra"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>
    </xsl:element>

</xsl:template>


<!--######## hnm_shoulder ########-->
<!--==============================-->
<xsl:template match="hnm_shoulder">
    <!--
    <!ELEMENT hnm_shoulder EMPTY>
    <!ATTLIST hnm_shoulder
        tag  ( %shoulder_tag; )  #REQUIRED
    >
    -->

    <xsl:element name="shoulder_movement">
        <xsl:attribute name="movement">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_body ########-->
<!--==========================-->
<xsl:template match="hnm_body">
    <!--
    <!ELEMENT hnm_body EMPTY>
    <!ATTLIST hnm_body
        tag  ( %body_tag; )  #REQUIRED
    >
    -->

    <xsl:element name="body_movement">
        <xsl:attribute name="movement">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_head ########-->
<!--==========================-->
<xsl:template match="hnm_head">
    <!--
    <!ELEMENT hnm_head EMPTY>
    <!ATTLIST hnm_head
        tag  ( %head_tag; )  #REQUIRED
    >
    -->

    <xsl:element name="head_movement">
        <xsl:attribute name="movement">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_eyegaze ########-->
<!--=============================-->
<xsl:template match="hnm_eyegaze">
    <!--
    <!ELEMENT hnm_eyegaze EMPTY>
    <!ATTLIST hnm_eyegaze
        tag  ( %eyegaze_tag; )  #REQUIRED
    >
    -->

    <xsl:element name="eye_gaze">
        <xsl:attribute name="direction">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_eyebrows ########-->
<!--==============================-->
<xsl:template match="hnm_eyebrows">
    <!--
    <!ELEMENT hnm_eyebrows EMPTY>
    <!ATTLIST hnm_eyebrows
        tag  ( %eyebrows_tag; )  #REQUIRED
    >
    -->

    <xsl:element name="eye_brows">
        <xsl:attribute name="movement">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_eyelids ########-->
<!--=============================-->
<xsl:template match="hnm_eyelids">
    <!--
    <!ELEMENT hnm_eyelids EMPTY>
    <!ATTLIST hnm_eyelids
        tag  ( %eyelids_tag; )  #REQUIRED
    >
    -->

    <xsl:element name="eye_lids">
        <xsl:attribute name="movement">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_nose ########-->
<!--==========================-->
<xsl:template match="hnm_nose">
    <!--
    <!ELEMENT hnm_nose EMPTY>
    <!ATTLIST hnm_nose
        tag  ( %nose_tag; )  #REQUIRED
    >
    -->

    <xsl:element name="nose">
        <xsl:attribute name="movement">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_mouthgesture ########-->
<!--==================================-->
<xsl:template match="hnm_mouthgesture">
    <!--
    <!ELEMENT hnm_mouthgesture EMPTY>
    <!ATTLIST hnm_mouthgesture
        tag  ( %mouthgesture_tag; )  #REQUIRED
    >
    -->

    <xsl:element name="mouth_gesture">
        <xsl:attribute name="movement">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_mouthpicture ########-->
<!--==================================-->
<xsl:template match="hnm_mouthpicture">
    <!--
    <!ELEMENT hnm_mouthpicture EMPTY>
    <!ATTLIST hnm_mouthpicture
        picture  CDATA  #REQUIRED
    >
    -->

    <xsl:element name="mouth_picture">
        <xsl:attribute name="picture">
            <xsl:value-of select="@picture"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


<!--######## hnm_extra ########-->
<!--==========================-->
<xsl:template match="hnm_extra">
    <!--
    <!ELEMENT hnm_extra EMPTY>
    <!ATTLIST hnm_extra
        tag  CDATA  #REQUIRED
    >
    -->

    <xsl:element name="extra_movement">
        <xsl:attribute name="movement">
            <xsl:value-of select="@tag"/>
        </xsl:attribute>
    </xsl:element>

</xsl:template>


</xsl:transform>
