<xsl:transform version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
pairOf18sTo26 is redundant (since the change to straight/circular
movement handling), 2003-08.
-->
<!--######## pairOf18sTo26 ########-->
<!--===============================-->
<!--
<xsl:template name="pairOf18sTo26">

    <xsl:param name="stra"/>
    <xsl:param name="strb"/>

    <xsl:choose>

        <xsl:when test="string-length($stra)=2 and string-length($strb)=2">
            <xsl:choose>
                <xsl:when test="substring($stra,2,1)=substring($strb,1,1)">
                    <xsl:value-of
                        select="concat($stra,substring($strb,2,1))"/>
                </xsl:when>
                <xsl:when test="substring($strb,2,1)=substring($stra,1,1)">
                    <xsl:value-of
                        select="concat($strb,substring($stra,2,1))"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$stra"/>
                </xsl:otherwise>
            </xsl:choose>

        </xsl:when>

        <xsl:otherwise>
            <xsl:value-of select="$stra"/>
        </xsl:otherwise>

    </xsl:choose>

</xsl:template>
-->


<!--######## checkBouncing ########-->
<!--===============================-->
<xsl:template name="checkBouncing">
    <xsl:if test="ancestor::action1[1]/@bouncing='true'">
       <xsl:attribute name="bouncing">true</xsl:attribute>
    </xsl:if>
</xsl:template>


<!--######## checkCurrentAlternating ########-->
<!--=========================================-->
<xsl:template name="checkCurrentAlternating">

    <xsl:if test="@alternating='true'">
       <xsl:attribute name="alternating">true</xsl:attribute>
         <xsl:if test="@second_alternating='true'">
           <xsl:attribute name="second_alternating">true</xsl:attribute>
        </xsl:if>
    </xsl:if>

</xsl:template>


<!--######## checkAncestorAlternating ########-->
<!--==========================================-->
<xsl:template name="checkAncestorAlternating">

    <xsl:variable name="ancstrtgt" select=
        "ancestor-or-self::*[name()='action1t' or name()='action2t'][1]"/>

    <!-- THIS IS THE POINT WHERE WE ENGAGE IN GROSS HACKERY IN -->
    <!-- ORDER TO DETERMINE WHETHER OR NOT SOME ANCESTOR HAS   -->
    <!-- ALREADY GENERATED ANY NECESSARY alternating           -->
    <!-- ATTRIBUTES.                                           -->

    <xsl:if test=
            "$ancstrtgt/@alternating='true'  and
             not($ancstrtgt/@repetition)  and
             ( count($ancstrtgt/*)=1  or
               count($ancstrtgt/action2/*)=1 )">

        <xsl:attribute name="alternating">true</xsl:attribute>
        <xsl:if test="$ancstrtgt/@second_alternating='true'">
            <xsl:attribute name="second_alternating">true</xsl:attribute>
        </xsl:if>

    </xsl:if>

</xsl:template>


<!--######## convertSize ########-->
<!--=============================-->
<xsl:template name="convertSize">
    <xsl:param name="sz"/>
    <xsl:choose>
        <xsl:when test="$sz='large'">big</xsl:when>
        <xsl:otherwise><xsl:value-of select="$sz"/></xsl:otherwise>
    </xsl:choose>
</xsl:template>


<!--######## rptValue ########-->
<!--==========================-->
<xsl:template name="rptValue">
    <xsl:param name="r"/>
    <xsl:choose>
        <xsl:when test="$r='fromstartseveral'">fromstart_several</xsl:when>
        <xsl:when test="$r='continueseveral'">continue_several</xsl:when>
        <xsl:otherwise><xsl:value-of select="$r"/></xsl:otherwise>
    </xsl:choose>
</xsl:template>


<!--######## setMainRepetitionAttribs ########-->
<!--==========================================-->
<xsl:template name="setMainRepetitionAttribs">
    <!--
    <!ATTLIST action?t
        repetition ( %repetition; ) #IMPLIED
        second_repetition ( %repetition; ) #IMPLIED
        repetition_incrdecr ( %incrdecr; ) #IMPLIED
        repetition_incrdecr_size ( %size; ) #IMPLIED
        repetition_baseshift ( %movementarrow; ) #IMPLIED
        baseshift_size ( %size; ) #IMPLIED
        baseshift_incrdecr ( %incrdecr; ) #IMPLIED
        baseshift_incrdecr_size ( %size; ) #IMPLIED
        approx_repetition  %boolfalse;
        ...
    >
    2011-04
    ADDED approx_repetition ATTRIBUTE  - MAY POSSIBLY APPEAR
    WHEN repetition='fromstartseveral' BUT NOT OTHERWISE.
    -->

    <xsl:attribute name="repetition">
        <xsl:call-template name="rptValue">
            <xsl:with-param name="r" select=
                "substring-after(@repetition,'ham_repeat_')"/>
        </xsl:call-template>
    </xsl:attribute>

    <xsl:if test="@second_repetition">
        <xsl:attribute name="second_repetition">
            <xsl:call-template name="rptValue">
                <xsl:with-param name="r" select=
                    "substring-after(@second_repetition,'ham_repeat_')"/>
            </xsl:call-template>
        </xsl:attribute>
    </xsl:if>

    <xsl:if test="@repetition_incrdecr">
        <xsl:attribute name="repetition_incrdecr">
            <xsl:value-of select=
                "substring-after(@repetition_incrdecr,'ham_')"/>
        </xsl:attribute>
    </xsl:if>

    <xsl:if test="@repetition_incrdecr_size">
      <xsl:attribute name="repetition_incrdecr_size">
        <xsl:call-template name="convertSize">
          <xsl:with-param name="sz" select="@repetition_incrdecr_size"/>
        </xsl:call-template>
      </xsl:attribute>
    </xsl:if>

    <xsl:if test="@repetition_baseshift">
        <xsl:attribute name="repetition_baseshift">
            <xsl:value-of select=
                "substring-after(@repetition_baseshift,'ham_move_')"/>
        </xsl:attribute>
    </xsl:if>

    <xsl:if test="@baseshift_size">
      <xsl:attribute name="baseshift_size">
        <xsl:call-template name="convertSize">
          <xsl:with-param name="sz" select="@baseshift_size"/>
        </xsl:call-template>
      </xsl:attribute>
    </xsl:if>

    <xsl:if test="@baseshift_incrdecr">
        <xsl:attribute name="baseshift_incrdecr">
            <xsl:value-of select=
                "substring-after(@baseshift_incrdecr,'ham_')"/>
        </xsl:attribute>
    </xsl:if>

    <xsl:if test="@baseshift_incrdecr_size">
      <xsl:attribute name="baseshift_incrdecr_size">
        <xsl:call-template name="convertSize">
          <xsl:with-param name="sz" select="@baseshift_incrdecr_size"/>
        </xsl:call-template>
      </xsl:attribute>
    </xsl:if>

    <xsl:if test="@approx_repetition='true'">
       <xsl:attribute name="approx_repetition">true</xsl:attribute>
       <xsl:call-template name="copyEllipsedirectionAttrib"/>
    </xsl:if>

</xsl:template>


<!--######## copySimpleParentAttribs ########-->
<!--=========================================-->
<xsl:template name="copySimpleParentAttribs">

    <xsl:if test="../@modifier">
        <xsl:attribute name="manner">
            <xsl:value-of select="substring-after(../@modifier,'ham_')"/>
        </xsl:attribute>
    </xsl:if>

    <xsl:if test="../@ham_fast='true'">
        <xsl:attribute name="fast">true</xsl:attribute>
    </xsl:if>

    <xsl:if test="../@ham_slow='true'">
        <xsl:attribute name="slow">true</xsl:attribute>
    </xsl:if>

    <xsl:if test="../@ham_tense='true'">
        <xsl:attribute name="tense">true</xsl:attribute>
    </xsl:if>

    <xsl:if test="../@ham_rest='true'">
        <xsl:attribute name="rest">true</xsl:attribute>
    </xsl:if>

    <xsl:if test="../@ham_halt='true'">
        <xsl:attribute name="halt">true</xsl:attribute>
    </xsl:if>

    <xsl:if test="../@def_locname">
        <xsl:attribute name="def_locname">
            <xsl:value-of
                select="substring-after(../@def_locname,'loc')"/>
        </xsl:attribute>
    </xsl:if>

    <xsl:if test="../@bouncing='true'">
        <xsl:attribute name="bouncing">true</xsl:attribute>
    </xsl:if>

    <xsl:if test="../@abs_motion='true'">
        <xsl:attribute name="abs_motion">true</xsl:attribute>
    </xsl:if>

</xsl:template>


<!--######## copySizeAttrib ########-->
<!--================================-->
<xsl:template name="copySizeAttrib">

    <xsl:if test="@size">
      <xsl:attribute name="size">
        <xsl:call-template name="convertSize">
          <xsl:with-param name="sz" select="@size"/>
        </xsl:call-template>
      </xsl:attribute>
    </xsl:if>

</xsl:template>


<!--######## copyDynamicsizeAttribs ########-->
<!--========================================-->
<xsl:template name="copyDynamicsizeAttribs">

    <xsl:if test="@incrdecr">
      <xsl:attribute name="incrdecr">
        <xsl:value-of select="substring-after(@incrdecr,'ham_')"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@incrdecr_size">
      <xsl:attribute name="incrdecr_size">
        <xsl:call-template name="convertSize">
          <xsl:with-param name="sz" select="@incrdecr_size"/>
        </xsl:call-template>
      </xsl:attribute>
    </xsl:if>

</xsl:template>


<!--######## copyEllipsedirectionAttrib ########-->
<!--============================================-->
<xsl:template name="copyEllipsedirectionAttrib">

    <xsl:if test="@ellipsedirection">
      <xsl:attribute name="ellipse_direction">
        <xsl:value-of select=
          "substring-after(@ellipsedirection,'ham_ellipse_')"/>
      </xsl:attribute>
    </xsl:if>

</xsl:template>


<!--######## copyZigzagAttribs ########-->
<!--===================================-->
<xsl:template name="copyZigzagAttribs">

    <xsl:if test="@zigzagstyle">
      <xsl:attribute name="zigzag_style">
        <xsl:value-of select="substring-after(@zigzagstyle,'ham_')"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@zigzag_size">
      <xsl:attribute name="zigzag_size">
        <xsl:call-template name="convertSize">
          <xsl:with-param name="sz" select="@zigzag_size"/>
        </xsl:call-template>
      </xsl:attribute>
    </xsl:if>

</xsl:template>


<!--######## copyClockAttribs ########-->
<!--==================================-->
<xsl:template name="copyClockAttribs">

    <xsl:if test="@start">
      <xsl:attribute name="start">
        <xsl:value-of select="substring-after(@start,'ham_clock_')"/>
      </xsl:attribute>
    </xsl:if>

    <xsl:if test="@clockfull='true'">
      <xsl:attribute name="clockplus">true</xsl:attribute>
    </xsl:if>

    <xsl:if test="@second_clockfull='true'">
      <xsl:attribute name="second_clockplus">true</xsl:attribute>
    </xsl:if>

    <xsl:if test="@end">
      <xsl:attribute name="end">
        <xsl:value-of select="substring-after(@end,'ham_clock_')"/>
      </xsl:attribute>
    </xsl:if>

</xsl:template>


</xsl:transform>
