<xsl:transform version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!--==================================================-->
<!--######## BASIC handshape ATTRIBUTE VALUES ########-->
<!--==================================================-->


<!--######## hShapeOld2New ########-->
<!--===============================-->
<xsl:template name="hShapeOld2New">
  <xsl:param name="hs"/>

    <xsl:choose>
        <xsl:when test="$hs='ham_flathand'">
            <xsl:value-of select="'flat'"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="substring-after($hs,'ham_')"/>
        </xsl:otherwise>
    </xsl:choose>

</xsl:template>


<!--######## handShapeValue ########-->
<!--================================-->
<xsl:template name="handShapeValue">

    <xsl:call-template name="hShapeOld2New">
        <xsl:with-param name="hs" select="@handshapeclass"/>
    </xsl:call-template>
</xsl:template>


<!--######## secondHandShapeValue ########-->
<!--======================================-->
<xsl:template name="secondHandShapeValue">

    <xsl:call-template name="hShapeOld2New">
        <xsl:with-param name="hs" select="@second_handshapeclass"/>
    </xsl:call-template>
</xsl:template>

<!--
<xsl:template name="handShapeValue">
    <xsl:choose>
        <xsl:when test="@handshapeclass='ham_flathand'">
            <xsl:value-of select="'flat'"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select=
                "substring-after(@handshapeclass,'ham_')"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>
-->


<!--=====================================================-->
<!--######## FINGER BENDING ATTRIBUTE CONVERSION ########-->
<!--=====================================================-->


<!--######## fBendOld2New ########-->
<!--==============================-->
<xsl:template name="fBendOld2New">
  <xsl:param name="fb"/>

  <xsl:variable name="sfb" select="substring-after($fb,'ham_finger_')"/>
  <xsl:choose>
    <xsl:when test="$sfb='straight'">bent</xsl:when>
    <xsl:when test="$sfb='bend'">round</xsl:when>
    <xsl:otherwise><xsl:value-of select="$sfb"/></xsl:otherwise>
  </xsl:choose>

</xsl:template>


<!--######## fBendName2Codes ########-->
<!--=================================-->
<xsl:template name="fBendName2Codes">
  <xsl:param name="fb"/>

  <xsl:choose>
    <xsl:when test="$fb=''">000</xsl:when>
    <xsl:when test="$fb='bent'">400</xsl:when>
    <xsl:when test="$fb='round'">222</xsl:when>
    <xsl:when test="$fb='hooked'">044</xsl:when>
    <xsl:when test="$fb='halfbent'">200</xsl:when>
    <xsl:when test="$fb='dblbent'">440</xsl:when>
    <xsl:when test="$fb='dblhooked'">444</xsl:when>
  </xsl:choose>

</xsl:template>


<!--######## fBend1DigitMerge ########-->
<!--==================================-->
<xsl:template name="fBend1DigitMerge">
  <xsl:param name="da"/>
  <xsl:param name="db"/>

  <xsl:variable name="sum" select="$da + $db"/>

  <xsl:value-of select="($sum - ($sum mod 2)) div 2"/>

</xsl:template>


<!--######## fBendDigitsMerge ########-->
<!--==================================-->
<xsl:template name="fBendDigitsMerge">
  <xsl:param name="dda"/>
  <xsl:param name="ddb"/>

  <xsl:variable name="d1">
    <xsl:call-template name="fBend1DigitMerge">
      <xsl:with-param name="da" select="substring($dda,1,1)"/>
      <xsl:with-param name="db" select="substring($ddb,1,1)"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:variable name="d2">
    <xsl:call-template name="fBend1DigitMerge">
      <xsl:with-param name="da" select="substring($dda,2,1)"/>
      <xsl:with-param name="db" select="substring($ddb,2,1)"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:variable name="d3">
    <xsl:call-template name="fBend1DigitMerge">
      <xsl:with-param name="da" select="substring($dda,3,1)"/>
      <xsl:with-param name="db" select="substring($ddb,3,1)"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:value-of select="concat($d1,$d2,$d3)"/>

</xsl:template>


<!--######## fBendPair2Codes ########-->
<!--=================================-->
<xsl:template name="fBendPair2Codes">
    <xsl:param name="fba"/>
    <xsl:param name="fbb"/>

    <xsl:variable name="fbacodes">
        <xsl:call-template name="fBendName2Codes">
            <xsl:with-param name="fb" select="$fba"/>
        </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="fbbcodes">
        <xsl:call-template name="fBendName2Codes">
            <xsl:with-param name="fb" select="$fbb"/>
        </xsl:call-template>
    </xsl:variable>

    <xsl:call-template name="fBendDigitsMerge">
        <xsl:with-param name="dda" select="$fbacodes"/>
        <xsl:with-param name="ddb" select="$fbbcodes"/>
    </xsl:call-template>

</xsl:template>


<!--================================================================-->
<!--######## GENERATING SIGML HANDSHAPE ATTRIBUTES FROM HML ########-->
<!--================================================================-->


<!--######## setMainBendAttrib ########-->
<!--===================================-->
<xsl:template name="setMainBendAttrib">

    <xsl:if test="@fingerbending">
        <xsl:attribute name="mainbend">
            <xsl:call-template name='fBendOld2New'>
                <xsl:with-param name="fb"
                    select="string(@fingerbending)"/>
            </xsl:call-template>
        </xsl:attribute>
    </xsl:if>
<!--
-->

</xsl:template>


<!--######## thumbPosOld2New ########-->
<!--=================================-->
<xsl:template name="thumbPosOld2New">
  <xsl:param name="oldthp"/>

    <xsl:variable name="thp"
            select="substring-after($oldthp,'ham_thumb_')"/>
    <xsl:choose>
        <xsl:when test="$thp='open'">opposed</xsl:when>
        <xsl:otherwise><xsl:value-of select="$thp"/></xsl:otherwise>
    </xsl:choose>

</xsl:template>


<!--######## thumbPos2CeeOpening ########-->
<!--=====================================-->
<xsl:template name="thumbPos2CeeOpening">
  <xsl:param name="thp"/>

    <!-- $thp IS EXPECTED TO HAVE ONLY TWO POSSIBLE VALUES HERE -->
    <xsl:choose>
        <xsl:when test="$thp='across'">tight</xsl:when>
        <xsl:when test="$thp='opposed'">slack</xsl:when>
    </xsl:choose>

</xsl:template>


<!--######## thumbposValue ########-->
<!--===============================-->
<xsl:template name="thumbposValue">

    <xsl:call-template name="thumbPosOld2New">
        <xsl:with-param name="oldthp" select="@thumbpos"/>
    </xsl:call-template>
<!--
    <xsl:variable name="thp" select=
        "substring-after(@thumbpos,'ham_thumb_')"/>
    <xsl:choose>
        <xsl:when test="$thp='open'">opposed</xsl:when>
        <xsl:otherwise><xsl:value-of select="$thp"/></xsl:otherwise>
    </xsl:choose>
-->
</xsl:template>


<!--######## secondThumbposValue ########-->
<!--=====================================-->
<xsl:template name="secondThumbposValue">

    <xsl:call-template name="thumbPosOld2New">
        <xsl:with-param name="oldthp" select="@second_thumbpos"/>
    </xsl:call-template>
</xsl:template>


<!--######## setThumbposAttrib ########-->
<!--===================================-->
<xsl:template name="setThumbposAttrib">

    <xsl:if test="@thumbpos">
        <xsl:attribute name="thumbpos">
            <xsl:call-template name="thumbposValue"/>
        </xsl:attribute>
    </xsl:if>

</xsl:template>


<!--######## setCeeopeningAttrib ########-->
<!--=====================================-->
<xsl:template name="setCeeopeningAttrib">

    <xsl:if test="@thumbpos">
        <xsl:variable name="tp">
            <xsl:call-template name="thumbposValue"/>
        </xsl:variable>
        <xsl:if test="$tp!='out'">
            <xsl:attribute name="ceeopening">
                <xsl:call-template name="thumbPos2CeeOpening">
                    <xsl:with-param name="thp" select="$tp"/>
                </xsl:call-template>
                <!--
                <xsl:choose>
                    <xsl:when test="$tp='across'">tight</xsl:when>
                    <xsl:when test="$tp='opposed'">slack</xsl:when>
                </xsl:choose>
                -->
            </xsl:attribute>
        </xsl:if>
    </xsl:if>

</xsl:template>


<!--######## checkExemptedDigits ########-->
<!--=====================================-->
<xsl:template name="checkExemptedDigits">

    <xsl:if test="@fingerbending | @second_fingerbending">
        <xsl:if test="fingernothumb | thumbspecial/thumb">
            <xsl:attribute name="exempteddigits">
                <xsl:if test="thumbspecial/thumb">1</xsl:if>
                <xsl:apply-templates select="fingernothumb"/>
            </xsl:attribute>
        </xsl:if>
    </xsl:if>

</xsl:template>


<!--######## checkExemptedThumbOnly ########-->
<!--========================================-->
<xsl:template name="checkExemptedThumbOnly">

    <xsl:if test="@fingerbending | @second_fingerbending">
        <xsl:if test="thumbspecial/thumb">
            <xsl:attribute name="exempteddigits">
                <xsl:value-of select="1"/>
            </xsl:attribute>
        </xsl:if>
    </xsl:if>

</xsl:template>


<!--######## setFingersAttrib ########-->
<!--==================================-->
<xsl:template name="setFingersAttrib">
    <xsl:param name="aname"/>

    <xsl:if test="fingernothumb">
        <xsl:attribute name="{$aname}">
            <xsl:apply-templates select="fingernothumb"/>
        </xsl:attribute>
    </xsl:if>

</xsl:template>


<!--######## checkOpposedFingerAttrib ########-->
<!--==================================-->
<xsl:template name="checkOpposedFingerAttrib">

    <xsl:if test="fingernothumb[@thumbopp='true']">
        <xsl:attribute name="opposedfinger">
            <xsl:apply-templates
                select="fingernothumb[@thumbopp='true']"/>
        </xsl:attribute>
    </xsl:if>

</xsl:template>


<!--######## setCombiningfingersAttribs ########-->
<!--===========================================-->
<xsl:template name="setCombiningfingersAttribs">
    <xsl:param name="hs"/>

    <xsl:if test="$hs!='pinchall' and $hs!='ceeall'">
        <xsl:call-template name="setFingersAttrib">
            <xsl:with-param name="aname" select="'specialfingers'"/>
        </xsl:call-template>
        <xsl:call-template name="checkOpposedFingerAttrib"/>
    </xsl:if>

</xsl:template>


<!--######## setContactPairAttribs ########-->
<!--=======================================-->
<xsl:template name="setContactPairAttribs">

    <xsl:if test="fingercrossing">
        <xsl:apply-templates select="fingercrossing[1]">
            <xsl:with-param name="tag" select="''"/>
        </xsl:apply-templates>
        <xsl:if test="fingercrossing[2]">
            <xsl:apply-templates select="fingercrossing[2]">
                <xsl:with-param name="tag" select="'second_'"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:if>

</xsl:template>


<!--######## setThumbContactAttrib ########-->
<!--=======================================-->
<xsl:template name="setThumbContactAttrib">

    <xsl:if test="thumbspecial/fingerpart">
        <xsl:apply-templates select="thumbspecial"/>
    </xsl:if>

</xsl:template>


<!--######## setThumbSpecialAttribs ########-->
<!--========================================-->
<xsl:template name="setThumbSpecialAttribs">

    <xsl:if test="thumbspecial">
       <xsl:if test="not(thumbspecial/thumb)">
           <xsl:apply-templates select="thumbspecial"/>
       </xsl:if>
    </xsl:if>

</xsl:template>


<!--######## checkApproxHSAttrib ########-->
<!--===============================-->
<xsl:template name="checkApproxHSAttrib">
    <xsl:if test="@approx_shape='true'">
       <xsl:attribute name="approx_shape">true</xsl:attribute>
    </xsl:if>
</xsl:template>


<!--=======================================================-->
<!--######## HANDSHAPE-DEPENDENT ATTRIBUTE SETTING ########-->
<!--=======================================================-->


<!--######## doFistHSAttribs ########-->
<!--=================================-->
<xsl:template name="doFistHSAttribs">

<!--####################
2003-08
Allow more attributes on a fist than hitherto
- main-bend, exempted-digits.
ViSiCAST D5-1 indicates we must do this for  HNS-4.
-->
    <!-- fingerbending ATTRIBUTE -->
    <xsl:call-template name="setMainBendAttrib"/>

    <!-- thumbpos ATTRIBUTE -->
    <xsl:call-template name="setThumbposAttrib"/>

    <!-- fingernothumb AND thumbspecial/thumb ELEMENTS -->
    <!-- (Do we need to exclude thumbspecial/thumb here?) -->
    <xsl:call-template name="checkExemptedDigits"/>

    <!-- fingershape ELEMENTS -> EXPLICIT bendN ATTRIBUTES -->
    <xsl:apply-templates select="fingershape"/>

    <!-- fingercrossing ELEMENTS -> contact ATTRIBUTES -->
    <xsl:call-template name="setContactPairAttribs"/>

    <!-- thumbspecial[not(thumb)] ELEMENT -->
    <xsl:call-template name="setThumbSpecialAttribs"/>

</xsl:template>


<!--######## doFlatHSAttribs ########-->
<!--=================================-->
<xsl:template name="doFlatHSAttribs">

    <!-- fingerbending ATTRIBUTE -->
    <xsl:call-template name="setMainBendAttrib"/>
    <!--
        <xsl:with-param name="baname" select="'mainbend'"/>
    </xsl:call-template>
    -->

    <!-- thumbpos ATTRIBUTE -->
    <xsl:call-template name="setThumbposAttrib"/>

    <!-- fingernothumb AND thumbspecial/thumb ELEMENTS -->
    <xsl:call-template name="checkExemptedDigits"/>

    <!-- fingershape ELEMENTS -> EXPLICIT bendN ATTRIBUTES -->
    <xsl:apply-templates select="fingershape"/>

    <!-- fingercrossing ELEMENTS -> contact ATTRIBUTES -->
    <xsl:call-template name="setContactPairAttribs"/>

    <!-- thumbspecial[not(thumb)] ELEMENT -->
    <xsl:call-template name="setThumbSpecialAttribs"/>

</xsl:template>


<!--######## doFinger2HSAttribs ########-->
<!--====================================-->
<xsl:template name="doFinger2HSAttribs">

    <!-- fingerbending ATTRIBUTE -->
    <xsl:call-template name="setMainBendAttrib"/>

    <!-- thumbpos ATTRIBUTE -->
    <xsl:call-template name="setThumbposAttrib"/>

    <!-- fingernothumb AND thumbspecial/thumb ELEMENTS -->
    <xsl:if test="count(fingernothumb)=1">
        <xsl:call-template name="setFingersAttrib">
            <xsl:with-param name="aname" select="'specialfingers'"/>
        </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="checkExemptedThumbOnly"/>

    <!-- fingershape ELEMENTS -> EXPLICIT bendN ATTRIBUTES -->
    <xsl:apply-templates select="fingershape"/>

    <!-- fingercrossing ELEMENTS -> contact ATTRIBUTES -->
    <xsl:call-template name="setContactPairAttribs"/>

    <!-- thumbspecial[not(thumb)] ELEMENT -->
    <xsl:call-template name="setThumbSpecialAttribs"/>

</xsl:template>


<!--######## doFinger23HSAttribs ########-->
<!--=====================================-->
<xsl:template name="doFinger23HSAttribs">

    <!-- fingerbending ATTRIBUTE -->
    <xsl:call-template name="setMainBendAttrib"/>

    <!-- thumbpos ATTRIBUTE -->
    <xsl:call-template name="setThumbposAttrib"/>

    <!-- fingernothumb AND thumbspecial/thumb ELEMENTS -->
    <xsl:choose>
        <xsl:when test="count(fingernothumb) &lt; 2">
            <xsl:call-template name="checkExemptedDigits"/>
        </xsl:when>
        <xsl:when test="count(fingernothumb) &gt;= 2">
            <xsl:call-template name="setFingersAttrib">
                <xsl:with-param name="aname" select="'specialfingers'"/>
            </xsl:call-template>
            <xsl:call-template name="checkExemptedThumbOnly"/>
        </xsl:when>
    </xsl:choose>

    <!-- fingershape ELEMENTS -> EXPLICIT bendN ATTRIBUTES -->
    <xsl:apply-templates select="fingershape"/>

    <!-- fingercrossing ELEMENTS -> contact ATTRIBUTES -->
    <xsl:call-template name="setContactPairAttribs"/>

    <!-- thumbspecial[not(thumb)] ELEMENT -->
    <xsl:call-template name="setThumbSpecialAttribs"/>

</xsl:template>


<!--######## doPinchHSAttribs ########-->
<!--==================================-->
<xsl:template name="doPinchHSAttribs">
    <xsl:param name="hs"/>

    <!-- fingerbending ATTRIBUTE -->
    <xsl:call-template name="setMainBendAttrib"/>

    <!-- fingernothumb ELEMENTS -->
    <xsl:call-template name="setCombiningfingersAttribs">
        <xsl:with-param name="hs" select="$hs"/>
    </xsl:call-template>
    <!-- ... or for exemption from a mainBend setting -->
    <xsl:call-template name="checkExemptedDigits"/>

    <!-- fingershape ELEMENTS -> EXPLICIT bendN ATTRIBUTES -->
    <xsl:apply-templates select="fingershape"/>

    <!-- fingercrossing ELEMENTS -> contact ATTRIBUTES -->
    <xsl:call-template name="setContactPairAttribs"/>

    <!-- fingerpart IS THE ONLY PERMITTED thumbspecial ELEMENT -->
    <xsl:call-template name="setThumbContactAttrib"/>

</xsl:template>


<!--######## doCeeHSAttribs ########-->
<!--================================-->
<xsl:template name="doCeeHSAttribs">
    <xsl:param name="hs"/>

    <!-- fingerbending ATTRIBUTE -->
    <xsl:call-template name="setMainBendAttrib"/>

    <!-- thumbpos ATTRIBUTE -->
    <xsl:call-template name="setCeeopeningAttrib"/>

    <!-- fingernothumb ELEMENTS -->
    <xsl:call-template name="setCombiningfingersAttribs">
        <xsl:with-param name="hs" select="$hs"/>
    </xsl:call-template>

    <!-- fingershape ELEMENTS -> EXPLICIT bendN ATTRIBUTES -->
    <xsl:apply-templates select="fingershape"/>

    <!-- fingercrossing ELEMENTS -> contact ATTRIBUTES -->
    <xsl:call-template name="setContactPairAttribs"/>

</xsl:template>


</xsl:transform>
