<xsl:transform version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
2004-02-10  CONVERTER FOR VISIA2/VISIA3 CAS FILES:

This converts bone-lengths and translation/position vectors
from mm to metres.

This conversion should be applied to CAS files which have been
generated before SiGMLSigning v2.6.2, but which are to be used
with v2.6.2 and above.
-->

<xsl:output method="xml" indent="yes" standalone="yes"/>

<xsl:template name="copyAttrib">
    <xsl:param name="aname"/>

    <xsl:variable name="anode" select="@*[name()=$aname]"/>
    <xsl:if test="$anode">
        <xsl:attribute name="{$aname}">
          <xsl:value-of select="$anode"/>
        </xsl:attribute>
    </xsl:if>
</xsl:template>

<xsl:template name="copyAttribScaleDown">
    <xsl:param name="aname"/>

    <xsl:variable name="anode" select="@*[name()=$aname]"/>
    <xsl:if test="$anode">
        <xsl:attribute name="{$aname}">
          <xsl:value-of select=
            "format-number(($anode div 1000.0),'####0.0000')"/>
        </xsl:attribute>
    </xsl:if>
</xsl:template>

<xsl:template match="/">

    <xsl:apply-templates select="*"/>
</xsl:template>

<!-- Most elements are unchanged at their own level: -->
<xsl:template match="CAS | Frames | Frame | Morph | QRotation">

  <xsl:copy>
    <xsl:copy-of select="@*"/>
    <xsl:apply-templates select="*"/>
  </xsl:copy>
</xsl:template>

<!-- Bone element: Length attribute may need "div 1000.0"  -->
<xsl:template match="Bone">

  <xsl:element name="Bone">
    <xsl:call-template name="copyAttrib">
      <xsl:with-param name="aname" select="'Index'"/>
    </xsl:call-template>
    <xsl:call-template name="copyAttrib">
      <xsl:with-param name="aname" select="'Name'"/>
    </xsl:call-template>
    <xsl:call-template name="copyAttribScaleDown">
      <xsl:with-param name="aname" select="'Length'"/>
    </xsl:call-template>

    <xsl:apply-templates select="*"/>
  </xsl:element>
</xsl:template>

<!-- Bone element: x,y,z attributes may need "div 1000.0"  -->
<xsl:template match="Position">

  <xsl:element name="Position">
    <xsl:call-template name="copyAttribScaleDown">
      <xsl:with-param name="aname" select="'x'"/>
    </xsl:call-template>
    <xsl:call-template name="copyAttribScaleDown">
      <xsl:with-param name="aname" select="'y'"/>
    </xsl:call-template>
    <xsl:call-template name="copyAttribScaleDown">
      <xsl:with-param name="aname" select="'z'"/>
    </xsl:call-template>
  </xsl:element>
</xsl:template>

</xsl:transform>
