/*
 * ResourceUtils.java		2002-03-15
 *
 * Ralph Elliott  <mailto:re@cmp.uea.ac.uk>
*/
package util;


import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Properties;


/** Utility methods for local resource file handling.
 */
public class ResourceUtils {

/** Relative prefix for this class's package. */
	private static final String			RELATIVE_PREFIX = "util/";
	private static final int			REL_PREFIX_SIZE =
										RELATIVE_PREFIX.length();

/** Cache of URI for the local resource base (typically our jar file). */
	private static String				localBasePrefix = null;

/** The current class as an object. */
	private static final Class<ResourceUtils>
										RU_CLASS = ResourceUtils.class;

/** Returns the URI of the local resource base. */
	protected static String getLocalBasePrefix() {

		if (localBasePrefix == null) {

			// The following contortions are needed because we
			// cannot prefix a resource string with "../", which
			// is what we really want to do.
			Class<ResourceUtils> cls = ResourceUtils.class;
			URL childurl = cls.getResource("ResourceUtils.class");
			String custr = childurl.toString();

			// Tail of custr is "util/ResourceUtils.class": we need
			// to remove everything after the penultimate '/'.
			int i = custr.lastIndexOf('/');
			i = custr.lastIndexOf('/', i-1);
			localBasePrefix = custr.substring(0, i+1);
		}

		return localBasePrefix;
	}

/** Returns the URI of the resource with the given local path,
 * i.e. path relative to our resource base.
 */
	public static String getLocalURI(String localpath) {

		return getLocalBasePrefix() + localpath;
	}

/** Returns an input stream for the resource with the given local path,
 * i.e. path relative to our resource base.
 */
	public static InputStream getStream(String localpath) {

		InputStream rins = null;

		if (localpath.startsWith(RELATIVE_PREFIX)) {

			final String R_NAME = localpath.substring(REL_PREFIX_SIZE);
			rins = RU_CLASS.getResourceAsStream(R_NAME);
		}
		else {
			System.out.println(
				"####  ResourceUtils.getStream(): "+
				"full URI needed for path "+localpath);

			String rurl = ResourceUtils.getLocalURI(localpath);
			try {
				rins = (new java.net.URL(rurl)).openStream();
			}
			catch (MalformedURLException mux) {
				System.out.println("####  For URI "+rurl+": "+mux);
			}
			catch (IOException iox) {
				System.out.println("####  For URI "+rurl+": "+iox);
			}
		}

		return rins;
	}

/** Loads and returns the properties held in the file with the given
 * local path, i.e. path relative to our resource base.
 */
	public static Properties getProperties(String localpath) {

		Properties props = null;

		if (localpath != null) {
			try {
				props = new Properties();
				InputStream pstrm = ResourceUtils.getStream(localpath);
				props.load(pstrm);
			}
			catch (IOException iox) {
				System.out.println(
					"Properties error (" + localpath + "): " +
					iox.getMessage());
				System.exit(1);
			}
		}

		return props;
	}
}
