/*	2010-10-25
 */
package symhns2hnsu;


import java.io.IOException;
import java.io.BufferedReader;


import static util.HNSUtils.getStdBufReader;
import static util.HNSUtils.getBufReader;
import static util.HNSUtils.readLines;
import static util.HNSUtils.hnsuItemsFromSymHNSItems;
import static util.HNSUtils.toStdOut;


/** Main class for the converter from symbolic manual HNS items to
 * HNS (Unicode) items.
 */
public class Main {

/** Converts symbolic manual HNS items to HNS (Unicode) items, one item
 * per line.
 * Each input item is a comma-separated list of manual HNS symbol names
 * (with <strong>no whitespace</strong>),
 * optionally followed by a single tab and a gloss name.
 * In the corresponding result item, the HNS symbols text is replaced by
 * the corresponding string of HNS (Unicode) characters.
 * The source items should be encoded as UTF-8, and are taken from
 * standard input unless an argument is provided, defining a file system
 * path for them.  The result is provided as UTF-8 on standard output.
 */
	public static void main(String[] args) throws IOException {

		final String PATH =
			args == null || args.length == 0 ? null : args[0];

		BufferedReader hnsrdr =
			PATH == null ? getStdBufReader() : getBufReader(PATH);

		String[] shlines = readLines(hnsrdr);

		String[] hnsui = hnsuItemsFromSymHNSItems(shlines);

		toStdOut(hnsui);
	}
}
