/*	2010-11-17
 */
package symhns2hns8;


import java.io.IOException;
import java.io.BufferedReader;


import static util.HNSUtils.getStdBufReader;
import static util.HNSUtils.getBufReader;
import static util.HNSUtils.readLines;
import static util.HNSUtils.hns8ItemsFromSymHNSItems;
import static util.HNSUtils.toStdOut;


/** Main class for the converter from symbolic manual HNS items to
 * classic (8-bit) manual HNS items.
 */
public class Main {

/** Converts symbolic manual HNS items to classic (8-bit) HNS items,
 * one item per line.
 * Each input item is a comma-separated list of manual HNS symbol names
 * (with <strong>no whitespace</strong>),
 * optionally followed by a single tab and a gloss name.
 * In the corresponding result item, the HNS symbols text is replaced by
 * the corresponding string of 8-bit HNS codes.
 * The source items should be encoded as UTF-8, and are taken from
 * standard input unless an argument is provided, defining a file system
 * path for them.  The result is provided as UTF-8 on standard output.
 */
	public static void main(String[] args) throws IOException {

		final String PATH =
			args == null || args.length == 0 ? null : args[0];

		BufferedReader hnsrdr =
			PATH == null ? getStdBufReader() : getBufReader(PATH);

		String[] shlines = readLines(hnsrdr);

		String[] hns8i = hns8ItemsFromSymHNSItems(shlines);

		toStdOut(hns8i);
	}
}
