/*	2010-10-25
 */
package hsigml2hnsu;


import java.io.IOException;
import java.io.BufferedReader;


import static util.HNSUtils.getStdBufReader;
import static util.HNSUtils.getBufReader;
import static util.HNSUtils.readLines;
import static util.HNSUtils.hnsuItemsFromHSiGML;
import static util.HNSUtils.toStdOut;


/** Main class for the converter from manual HNS SiGML to HNS (Unicode)
 * items.
 */
public class Main {

/** Converts a manual HNS SiGML document into HNS (Unicode) items, one
 * item per line.
 * The source document is assumed to be UTF-8, and is taken from standard
 * input, unless an argument is provided, defining a file system path for
 * it.
 * Gestural SiGML signs in the input are ignored, as are non-manuals in
 * HNS SiGML signs.
 * Each output item is a single line consisting of the string of
 * HNS (Unicode) characters corresponding to (the manual part of)
 * the original HNS SiGML sign, followed by a tab and the sign's gloss
 * name.
 * The result is provided as UTF-8 on standard output.
 */
	public static void main(String[] args) throws IOException {

		final String PATH =
			args == null || args.length == 0 ? null : args[0];

		BufferedReader srdr =
			PATH == null ? getStdBufReader() : getBufReader(PATH);

		String[] slines = readLines(srdr);

		String[] hnsu = hnsuItemsFromHSiGML(slines);

		toStdOut(hnsu);
	}
}
