/*	2010-10-25
 */
package hnsu2symhns;


import java.io.IOException;
import java.io.BufferedReader;


import static util.HNSUtils.getStdBufReader;
import static util.HNSUtils.getBufReader;
import static util.HNSUtils.readLines;
import static util.HNSUtils.symHNSItemsFromHNSUItems;
import static util.HNSUtils.toStdOut;


/** Main class for the converter from manual HNS (Unicode) items to
 * "symbolic HNS" items, that is, items with HNS symbol names.
 */
public class Main {

/** Converts manual HNS (Unicode) items to symbolic HNS items,
 * one per line.
 * Each source item is a string of manual HNS (Unicode) characters,
 * optionally followed by a tab and a gloss name.
 * In the corresponding result item the HNS string is replaced by the
 * corresponding list of HNS symbol names, separated by commas.
 * The source items should be encoded as UTF-8, and are taken from
 * standard input unless an argument is provided, defining a file system
 * path for them.  The result is provided (as UTF-8) on standard output.
 */
	public static void main(String[] args) throws IOException {

		final String PATH =
			args == null || args.length == 0 ? null : args[0];

		BufferedReader hnsrdr =
			PATH == null ? getStdBufReader() : getBufReader(PATH);

		String[] hulines = readLines(hnsrdr);

		String[] symhns = symHNSItemsFromHNSUItems(hulines);

		toStdOut(symhns);
	}
}
