/*	2010-10-25
 */
package hnsu2sigml;


import java.io.IOException;
import java.io.BufferedReader;


import static util.HNSUtils.getStdBufReader;
import static util.HNSUtils.getBufReader;
import static util.HNSUtils.readLines;
import static util.HNSUtils.sigmlFromHNSUItems;
import static util.HNSUtils.indentXML;
import static util.HNSUtils.toStdOut;


/** Main class for the converter of manual HNS (Unicode) items to
 * a SiGML document.
 */
public class Main {

/** Converts a sequence of manual HNS (Unicode) items, one per line,
 * to an HNS SiGML document.
 * Each source item is a string of manual HNS (Unicode) characters,
 * optionally followed by a tab and a gloss name.
 * The source items should be encoded as UTF-8, and are taken from
 * standard input unless an argument is provided, defining a file system
 * path for them.  The result is provided as UTF-8 on standard output.
 */
	public static void main(String[] args) throws IOException {

		final String PATH =
			args == null || args.length == 0 ? null : args[0];

		BufferedReader hnsrdr =
			PATH == null ? getStdBufReader() : getBufReader(PATH);

		String[] hlines = readLines(hnsrdr);

		String[] hnssigml = sigmlFromHNSUItems(hlines);

		toStdOut(indentXML(hnssigml));
	}
}
