/*	2010-10-25
 */
package hns8bit2sigml;


import java.io.IOException;
import java.io.BufferedReader;


import static util.HNSUtils.getStdBufReader;
import static util.HNSUtils.getBufReader;
import static util.HNSUtils.readLines;
import static util.HNSUtils.sigmlFromHNS8Items;
import static util.HNSUtils.indentXML;
import static util.HNSUtils.toStdOut;


/** Main class for the converter from classic (8-bit) manual HNS items to
 * a (manual HNS) SiGML document.
 */
public class Main {

/** Converts a sequence of classic (8-bit) manual HNS items, one per line,
 * to an HNS SiGML document.
 * Each source item is a sequence of classic 8-bit manual HNS characters,
 * masquerading as a string of Unicode characters with code points in
 * the same range [0..255], optionally followed by a tab and a gloss name.
 * The source items should be encoded as UTF-8, and are taken from
 * standard input unless an argument is provided, defining a file system
 * path for them.  The result is provided as UTF-8 on standard output.
 */
	public static void main(String[] args) throws IOException {

		final String PATH =
			args == null || args.length == 0 ? null : args[0];

		BufferedReader hnsrdr =
			PATH == null ? getStdBufReader() : getBufReader(PATH);

		String[] hlines = readLines(hnsrdr);

		String[] hnssigml = sigmlFromHNS8Items(hlines);

		toStdOut(indentXML(hnssigml));
	}
}
