/*
 * Decompiled with CFR 0.152.
 */
package sigml2gsigml;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import sigmlinlib.SiGMLInLib;
import util.HNSUtils;

public class Main {
    public static void main(String[] args) throws IOException {
        if (args != null && 2 <= args.length && args[0].equals("-d")) {
            Main.convertDir(args);
        } else {
            String[] hsigml;
            String hsigmldoc;
            String[] tog;
            int pathix = -1;
            int hmlix = -1;
            if (args != null && args.length != 0) {
                if (args.length == 1) {
                    if (args[0].startsWith("-")) {
                        hmlix = 0;
                    } else {
                        pathix = 0;
                    }
                } else if (args.length == 2) {
                    pathix = 0;
                    if (2 <= args[1].length()) {
                        hmlix = 1;
                    }
                } else {
                    System.err.println("args:  [ <sigml-file> ] [ -hml ]");
                }
            }
            String PATH = pathix < 0 ? null : args[pathix];
            boolean SHOW_HML = 0 <= hmlix && "-hml".startsWith(args[hmlix]);
            BufferedReader hrdr = PATH == null ? HNSUtils.getStdBufReader() : HNSUtils.getBufReader((String)PATH);
            SiGMLInLib SIL = new SiGMLInLib();
            if (SHOW_HML) {
                SIL.setEnabledLogHML(SHOW_HML);
            }
            if (!(tog = SIL.sigmlSignsToGestural(hsigmldoc = HNSUtils.joinLines((String[])(hsigml = HNSUtils.readLines((BufferedReader)hrdr)))))[2].equals("0")) {
                String errmsg = tog[3];
                System.err.println("SiGML conversion error(s):");
                System.err.println(errmsg);
                System.err.println("SiGML conversion error count: " + tog[2]);
            }
            String[] gsigml = tog[1].split("\n");
            HNSUtils.toStdOut((String[])gsigml);
        }
    }

    private static void convertDir(String[] args) throws IOException {
        String IN_DIR_S = args[1];
        String OUT_DIR_S = 3 <= args.length ? args[2] : IN_DIR_S + "-g";
        File IN_DIR = new File(IN_DIR_S);
        File OUT_DIR = new File(OUT_DIR_S);
        if (!IN_DIR.exists()) {
            System.err.println("Missing directory: " + IN_DIR_S);
        }
        if (OUT_DIR.exists()) {
            System.err.println("Directory (or file) already exists: " + OUT_DIR_S);
        } else {
            boolean outok = OUT_DIR.mkdirs();
            if (!outok) {
                System.err.println("Directory creation failure: " + OUT_DIR_S);
            } else {
                Main.convertDir(IN_DIR, OUT_DIR);
            }
        }
    }

    private static void convertDir(File IN_DIR, File OUT_DIR) throws IOException {
        String[] S_STEMS;
        SiGMLInLib SIGML_IN_LIB = new SiGMLInLib();
        for (String sstem : S_STEMS = Main.sigmlStems(IN_DIR)) {
            BufferedReader srdr = HNSUtils.getBufReader((String)(IN_DIR + "/" + sstem + ".sigml"));
            String[] sigml = HNSUtils.readLines((BufferedReader)srdr);
            String sigmldoc = HNSUtils.joinLines((String[])sigml);
            String[] tog = SIGML_IN_LIB.sigmlSignsToGestural(sigmldoc);
            if (tog[2].equals("0")) {
                String[] gsigml = tog[1].split("\n");
                String GS_FILE = sstem + "-g.sigml";
                PrintStream gsout = HNSUtils.filePrintStream((File)OUT_DIR, (String)GS_FILE);
                HNSUtils.toStream((String[])gsigml, (PrintStream)gsout);
                gsout.close();
                continue;
            }
            String errmsg = tog[3];
            System.err.println("SiGML conversion error(s) for " + sstem + ".sigml: ");
            System.err.println(errmsg);
        }
    }

    private static String[] sigmlStems(File DIR) {
        String TAIL = ".sigml";
        int T_LEN = ".sigml".length();
        Object[] fnames = DIR.list();
        Arrays.sort(fnames);
        int N = fnames.length;
        for (int i = 0; i != N; ++i) {
            Object fnm = fnames[i];
            if (!((String)fnm).endsWith(".sigml")) continue;
            fnames[i] = ((String)fnm).substring(0, ((String)fnm).length() - T_LEN);
        }
        return fnames;
    }
}

