/*
 * Decompiled with CFR 0.152.
 */
package gsigml2hnsu;

import hnscnvt.HNSSign;
import hnsgen.GToHNSSignSiGML;
import java.io.BufferedReader;
import java.io.IOException;
import sigmlinlib.SiGMLInLib;
import util.HNSUtils;

public class Main {
    public static void main(String[] args) throws IOException {
        String PATH = args == null || args.length == 0 ? null : args[0];
        BufferedReader grdr = PATH == null ? HNSUtils.getStdBufReader() : HNSUtils.getBufReader((String)PATH);
        String[] gsigml = HNSUtils.readLines((BufferedReader)grdr);
        String[] hnsu = Main.gSiGMLToHNS(gsigml);
        HNSUtils.toStdOut((String[])hnsu);
    }

    private static String[] gSiGMLToHNS(String[] gsigml) {
        SiGMLInLib SIL = new SiGMLInLib();
        String[][] gsdocs = HNSUtils.signDocsFromSigns((String[][])HNSUtils.signsFromSiGMLDoc((String[])gsigml));
        int N = gsdocs.length;
        String[] hnsmans = new String[N];
        String[] glosses = new String[N];
        for (int i = 0; i != N; ++i) {
            String gsdoc = HNSUtils.joinLines((String[])gsdocs[i]);
            try {
                HNSSign[] hsigns = SIL.gesturalSiGMLToHNS(gsdoc);
                if (hsigns.length == 0) {
                    hnsmans[i] = "";
                    glosses[i] = "sign_" + i;
                    Main.reportGToHErr(i, "sign is not gestural SiGML");
                    continue;
                }
                HNSSign hs = hsigns[0];
                hnsmans[i] = hs.man();
                glosses[i] = hs.gloss();
                continue;
            }
            catch (GToHNSSignSiGML.GToHNSException gtohx) {
                hnsmans[i] = "";
                glosses[i] = "sign_" + i;
                Main.reportGToHErr(i, gtohx.toString());
                System.err.println();
            }
        }
        String[] hnsu = HNSUtils.hnsuFromHNS8((String[])hnsmans);
        String[] hlines = new String[N];
        for (int j = 0; j != N; ++j) {
            hlines[j] = hnsu[j] + "\t" + glosses[j];
        }
        return hlines;
    }

    private static void reportGToHErr(int ix, String msg) {
        System.err.println("gSiGMLToHNS() at item " + ix + ": " + msg);
    }
}

