/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Enumeration;
import java.util.Properties;
import util.ResourceUtils;

public class ToSafeASCIIMap {
    protected static final String A0_FF_MAP = "util/mapA0-FFRangeToASCII.txt";
    private static ToSafeASCIIMap TO_SAFE_ASCII_MAP = null;
    public static final int A0 = 160;
    public static final int T_LIM = 256;
    public static final int A0_TABLE_SIZE = 96;
    public static final String DEFAULT_CHAR = "_";
    public final String[] A0_TABLE = new String[96];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ToSafeASCIIMap getToSafeASCIIMap() {
        if (TO_SAFE_ASCII_MAP != null) return TO_SAFE_ASCII_MAP;
        Class<ToSafeASCIIMap> clazz = ToSafeASCIIMap.class;
        synchronized (ToSafeASCIIMap.class) {
            if (TO_SAFE_ASCII_MAP != null) return TO_SAFE_ASCII_MAP;
            TO_SAFE_ASCII_MAP = new ToSafeASCIIMap(A0_FF_MAP);
            // ** MonitorExit[var0] (shouldn't be in output)
            return TO_SAFE_ASCII_MAP;
        }
    }

    private ToSafeASCIIMap(String a0propspath) {
        for (int i = 0; i != 96; ++i) {
            this.A0_TABLE[i] = DEFAULT_CHAR;
        }
        Properties props = ResourceUtils.getProperties(a0propspath);
        Enumeration<?> pen = props.propertyNames();
        while (pen.hasMoreElements()) {
            String chrstr = (String)pen.nextElement();
            int CHAR = Integer.decode(chrstr);
            String TOK = ToSafeASCIIMap.getFirstPropsToken(props, chrstr);
            this.A0_TABLE[CHAR - 160] = TOK != null ? TOK : DEFAULT_CHAR;
        }
    }

    public String safe(char ch) {
        String cstr = this.map(ch);
        return cstr != null ? cstr : "" + ch;
    }

    public String safe(String str) {
        StringBuilder sbuf = new StringBuilder((int)(1.5 * (double)str.length()));
        for (char ch : str.toCharArray()) {
            String chstr = this.map(ch);
            if (chstr != null) {
                sbuf.append(chstr);
                continue;
            }
            sbuf.append(ch);
        }
        return sbuf.toString();
    }

    private String map(char ch) {
        String cstr = null;
        if (!(ch == '-' || ch == '_' || ch == '.' || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9')) {
            cstr = '\u00a0' <= ch && ch < '\u0100' ? this.A0_TABLE[ch - 160] : (ch == '@' ? "at" : DEFAULT_CHAR);
        }
        return cstr;
    }

    protected static String getFirstPropsToken(Properties props, String istr) {
        String[] ptoks;
        String pfirst = null;
        String pstr = props.getProperty(istr);
        if (pstr != null && (ptoks = pstr.split("[ \\t]+", 2))[0].length() != 0) {
            pfirst = ptoks[0];
        }
        return pfirst;
    }
}

