/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ResourceUtils {
    private static final String RELATIVE_PREFIX = "util/";
    private static final int REL_PREFIX_SIZE = "util/".length();
    private static String localBasePrefix = null;
    private static final Class<ResourceUtils> RU_CLASS = ResourceUtils.class;

    protected static String getLocalBasePrefix() {
        if (localBasePrefix == null) {
            Class<ResourceUtils> cls = ResourceUtils.class;
            URL childurl = cls.getResource("ResourceUtils.class");
            String custr = childurl.toString();
            int i = custr.lastIndexOf(47);
            i = custr.lastIndexOf(47, i - 1);
            localBasePrefix = custr.substring(0, i + 1);
        }
        return localBasePrefix;
    }

    public static String getLocalURI(String localpath) {
        return ResourceUtils.getLocalBasePrefix() + localpath;
    }

    public static InputStream getStream(String localpath) {
        InputStream rins = null;
        if (localpath.startsWith(RELATIVE_PREFIX)) {
            String R_NAME = localpath.substring(REL_PREFIX_SIZE);
            rins = RU_CLASS.getResourceAsStream(R_NAME);
        } else {
            System.out.println("####  ResourceUtils.getStream(): full URI needed for path " + localpath);
            String rurl = ResourceUtils.getLocalURI(localpath);
            try {
                rins = new URL(rurl).openStream();
            }
            catch (MalformedURLException mux) {
                System.out.println("####  For URI " + rurl + ": " + mux);
            }
            catch (IOException iox) {
                System.out.println("####  For URI " + rurl + ": " + iox);
            }
        }
        return rins;
    }

    public static Properties getProperties(String localpath) {
        Properties props = null;
        if (localpath != null) {
            try {
                props = new Properties();
                InputStream pstrm = ResourceUtils.getStream(localpath);
                props.load(pstrm);
            }
            catch (IOException iox) {
                System.out.println("Properties error (" + localpath + "): " + iox.getMessage());
                System.exit(1);
            }
        }
        return props;
    }
}

