/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import util.ResourceUtils;

public class HamNameMap {
    protected static final String HNS_TAG_FILE = "util/octetToHam4Tags.txt";
    protected static final String HNS_ALT_SPELL_FILE = "util/altSpellingsHam4Tags.txt";
    protected static final String HAM_VERSION40 = "hamversion40";
    protected static final String HAM_SPACE = "hamspace";
    protected static HamNameMap hamNames = null;
    protected static final int O_NULL = 0;
    protected static final int O_MAX = 256;
    protected String[] o2h = new String[256];
    protected HashMap<String, Integer> h2o;
    protected final int O_HAMVERSION;
    protected final int O_HAMSPACE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HamNameMap getStdHamNameMap() {
        if (hamNames != null) return hamNames;
        Class<HamNameMap> clazz = HamNameMap.class;
        synchronized (HamNameMap.class) {
            if (hamNames != null) return hamNames;
            Properties hnprops = ResourceUtils.getProperties(HNS_TAG_FILE);
            Properties hnaltspellprops = ResourceUtils.getProperties(HNS_ALT_SPELL_FILE);
            hamNames = new HamNameMap(hnprops, null, hnaltspellprops);
            // ** MonitorExit[var0] (shouldn't be in output)
            return hamNames;
        }
    }

    protected HamNameMap(Properties hnmain, Properties hnextra) {
        this(hnmain, hnextra, null);
    }

    protected HamNameMap(Properties hnmain, Properties hnextra, Properties hnaltspell) {
        int HSPACE;
        int HVER;
        this.updateO2HMap(hnmain);
        if (hnextra != null) {
            this.updateO2HMap(hnextra);
        }
        this.h2o = new HashMap();
        this.makeH2OMap();
        if (hnaltspell != null) {
            this.addAltSpellingsToH2OMap(hnaltspell);
        }
        if ((HVER = this.octet(HAM_VERSION40)) == 0) {
            HamNameMap.badOperand(HAM_VERSION40);
        }
        if ((HSPACE = this.octet(HAM_SPACE)) == 0) {
            HamNameMap.badOperand(HAM_SPACE);
        }
        this.O_HAMVERSION = HVER;
        this.O_HAMSPACE = HSPACE;
    }

    public String hamName(int o) {
        return 0 <= o && o < 256 ? this.o2h[o] : null;
    }

    public int octet(String hamname) {
        Integer O_OBJ = this.h2o.get(hamname);
        return O_OBJ == null ? 0 : O_OBJ;
    }

    public int cleanOctet(String hamname) {
        int OCT = this.octet(hamname);
        return 0 < OCT && OCT <= this.O_HAMSPACE && OCT != this.O_HAMVERSION ? 0 : OCT;
    }

    public String[] hamNameSet() {
        return this.h2o.keySet().toArray(new String[0]);
    }

    public String[] hamNameSetAscending() {
        Comparator<String> bcomp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer I1 = HamNameMap.this.h2o.get(o1);
                Integer I2 = HamNameMap.this.h2o.get(o2);
                int cmp = 0;
                if (I1 != null && I2 == null) {
                    cmp = -1;
                } else if (I1 == null && I2 != null) {
                    cmp = 1;
                } else if (I1 != null && I2 != null) {
                    cmp = I1 - I2;
                }
                return cmp;
            }
        };
        Set<String> NAMES = this.h2o.keySet();
        int N = NAMES.size();
        String[] hnms = new String[N];
        NAMES.toArray(hnms);
        Arrays.sort(hnms, bcomp);
        return hnms;
    }

    protected void updateO2HMap(Properties hnprops) {
        Enumeration<?> hnen = hnprops.propertyNames();
        while (hnen.hasMoreElements()) {
            String ostr = (String)hnen.nextElement();
            String hn = HamNameMap.getFirstPropsToken(hnprops, ostr);
            if (!hn.startsWith("ham")) continue;
            this.o2h[HamNameMap.s2i((String)ostr)] = hn;
        }
    }

    protected void makeH2OMap() {
        for (int o = 0; o != 256; ++o) {
            String hn = this.o2h[o];
            if (hn == null || this.h2o.get(hn) != null) continue;
            this.h2o.put(new String(hn), new Integer(o));
        }
    }

    protected void addAltSpellingsToH2OMap(Properties hnaltspell) {
        Enumeration<?> asen = hnaltspell.propertyNames();
        while (asen.hasMoreElements()) {
            String altstr = (String)asen.nextElement();
            String stdstr = HamNameMap.getFirstPropsToken(hnaltspell, altstr);
            int stdval = this.octet(stdstr);
            if (stdval == 0) continue;
            this.h2o.put(altstr, stdval);
        }
    }

    protected static String getFirstPropsToken(Properties props, String istr) {
        String pstr = props.getProperty(istr);
        String pfirst = pstr.split("[ \t]+", 2)[0];
        return pfirst;
    }

    protected static int s2i(String s) {
        return Integer.decode(s);
    }

    public String[] cleanHamNameVec(String[] hamnv, int ix) {
        String[] hnsnvclean = hamnv;
        int N = hamnv.length;
        int nbad = 0;
        for (String hamn : hamnv) {
            if (this.cleanOctet(hamn) != 0) continue;
            ++nbad;
        }
        if (nbad != 0) {
            int NG = N - nbad;
            hnsnvclean = new String[NG];
            int g = 0;
            int j = 0;
            for (String hname : hamnv) {
                if (this.cleanOctet(hname) != 0) {
                    hnsnvclean[g] = hname;
                    ++g;
                } else {
                    HamNameMap.invalidMsg(ix, j, "HNS symbol name \"" + hname + "\"");
                }
                ++j;
            }
        }
        return hnsnvclean;
    }

    private static void invalidMsg(int i, int j, String item) {
        String MSG = "In item " + i + ": rejected " + item + " at position " + j + ".";
        System.err.println(MSG);
    }

    protected static final void badOperand(String tag) {
        throw new IllegalArgumentException("HamNameMap: invalid name: " + tag);
    }
}

