/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import util.HNSOctetUCSMap;
import util.HamNameMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HNSUtils {
    public static final String EOL = "\n";
    public static final String SIGML = "sigml";
    public static final String HNS_SIGN = "hns_sign";
    public static final String HNS_MANUAL = "hamnosys_manual";
    public static final String HAM_GEST_SIGN = "hamgestural_sign";
    public static final String SIGN_MANUAL = "sign_manual";
    public static final String GLOSS = "gloss";
    public static final String STD_ENCODING = "utf-8";
    public static final String STD_XML_DECL = HNSUtils.XML_DECL("utf-8");
    private static final String SPACES = "                                                                                                                        ";

    public static String[][] signDocsFromSigns(String[][] signs) {
        int N = signs.length;
        String[][] sdocs = new String[N][];
        for (int i = 0; i != N; ++i) {
            sdocs[i] = HNSUtils.prefix(STD_XML_DECL, HNSUtils.EL_WRAP(SIGML, HNSUtils.trim(signs[i])));
        }
        return sdocs;
    }

    public static String[][] signsFromSiGMLDoc(String[] sigml) {
        String[] signels = new String[]{HNS_SIGN, HAM_GEST_SIGN};
        return HNSUtils.elSeqFromSimpleXML(signels, sigml);
    }

    public static String[] sigmlFromHNSUItems(String[] hnsui) {
        int N = hnsui.length;
        String[] glosses = HNSUtils.glossesFromHNSItems(hnsui);
        String[] hnsu = HNSUtils.cleanHNSU(HNSUtils.hnsFromHNSItems(hnsui));
        String[][] hnvecs = HNSUtils.hnsNameVecsFromHNSU(hnsu);
        String[][] hsigns = new String[N][];
        for (int i = 0; i != N; ++i) {
            hsigns[i] = HNSUtils.hnsSignFromHNSNameVec(hnvecs[i], glosses[i]);
        }
        return HNSUtils.prefix(STD_XML_DECL, HNSUtils.EL_WRAP(SIGML, HNSUtils.merge(hsigns)));
    }

    public static String[] sigmlFromHNS8Items(String[] hns8i) {
        int N = hns8i.length;
        String[] glosses = HNSUtils.glossesFromHNSItems(hns8i);
        String[] hns8 = HNSUtils.cleanHNS8(HNSUtils.hnsFromHNSItems(hns8i));
        String[][] hnvecs = HNSUtils.hnsNameVecsFromHNS8(hns8);
        String[][] hsigns = new String[N][];
        for (int i = 0; i != N; ++i) {
            hsigns[i] = HNSUtils.hnsSignFromHNSNameVec(hnvecs[i], glosses[i]);
        }
        return HNSUtils.prefix(STD_XML_DECL, HNSUtils.EL_WRAP(SIGML, HNSUtils.merge(hsigns)));
    }

    public static String[] hnsuItemsFromHNS8Items(String[] hns8i) {
        String[] hns8 = HNSUtils.cleanHNS8(HNSUtils.hnsFromHNSItems(hns8i));
        String[] hnsui = HNSUtils.hnsuFromHNS8(hns8);
        return HNSUtils.zip(hnsui, HNSUtils.tailsFromHNSItems(hns8i));
    }

    public static String[] hns8ItemsFromSymHNSItems(String[] symhnsi) {
        return HNSUtils.zip(HNSUtils.hns8FromSymHNSItems(symhnsi), HNSUtils.tailsFromHNSItems(symhnsi));
    }

    public static String[] hns8FromSymHNSItems(String[] symhnsi) {
        return HNSUtils.hns8FromHNSNameVecs(HNSUtils.hnsNameVecsFromSymHNS(HNSUtils.hnsFromHNSItems(symhnsi)));
    }

    public static String[] symHNSItemsFromHNSUItems(String[] hnsui) {
        return HNSUtils.zip(HNSUtils.symHNSFromHNSUItems(hnsui), HNSUtils.tailsFromHNSItems(hnsui));
    }

    public static String[] hnsuItemsFromSymHNSItems(String[] symhnsi) {
        return HNSUtils.zip(HNSUtils.hnsuFromSymHNSItems(symhnsi), HNSUtils.tailsFromHNSItems(symhnsi));
    }

    public static String[] symHNSFromHNSUItems(String[] hnsui) {
        String[] hnsu = HNSUtils.cleanHNSU(HNSUtils.hnsFromHNSItems(hnsui));
        return HNSUtils.symHNSFromHNSNameVecs(HNSUtils.hnsNameVecsFromHNSU(hnsu));
    }

    public static String[] hnsuFromSymHNSItems(String[] symhnsi) {
        return HNSUtils.hnsuFromHNSNameVecs(HNSUtils.hnsNameVecsFromSymHNS(HNSUtils.hnsFromHNSItems(symhnsi)));
    }

    public static String[][] hnsNameVecsFromSymHNS(String[] symhns) {
        return HNSUtils.hnsNameVecsFromSymHNS(symhns, ",");
    }

    public static String[][] hnsNameVecsFromSymHNS(String[] symhns, String sep) {
        int N = symhns.length;
        String[][] hnsnv = new String[N][];
        for (int i = 0; i != N; ++i) {
            String SYMH = symhns[i];
            hnsnv[i] = SYMH.length() == 0 ? new String[]{} : SYMH.split(sep);
        }
        return HNSUtils.cleanHamNameVecs(hnsnv);
    }

    public static String[] symHNSFromHNSNameVecs(String[][] hnsnv) {
        return HNSUtils.symHNSFromHNSNameVecs(hnsnv, ",");
    }

    public static String[] symHNSFromHNSNameVecs(String[][] hnsnv, String sep) {
        int N = hnsnv.length;
        String[] symhns = new String[N];
        for (int i = 0; i != N; ++i) {
            symhns[i] = HNSUtils.join(hnsnv[i], sep);
        }
        return symhns;
    }

    public static String[] hnsuFromHNSNameVecs(String[][] hnsnv) {
        return HNSUtils.hnsuFromHNS8(HNSUtils.hns8FromHNSNameVecs(hnsnv));
    }

    public static String[] hns8FromHNSNameVecs(String[][] hnsnv) {
        HamNameMap hnmmap = HamNameMap.getStdHamNameMap();
        int N = hnsnv.length;
        String[] hns8 = new String[N];
        for (int s = 0; s != N; ++s) {
            String[] H_N_VEC = hnsnv[s];
            int N_CH = H_N_VEC.length;
            char[] hoctets = new char[N_CH];
            for (int i = 0; i != N_CH; ++i) {
                hoctets[i] = (char)hnmmap.octet(H_N_VEC[i]);
            }
            hns8[s] = new String(hoctets);
        }
        return hns8;
    }

    public static String[][] hnsNameVecsFromHNSU(String[] hnsu) {
        return HNSUtils.hnsNameVecsFromHNS8(HNSUtils.hns8FromHNSU(hnsu));
    }

    public static String[][] hnsNameVecsFromHNS8(String[] hns8) {
        HamNameMap hnmmap = HamNameMap.getStdHamNameMap();
        int N = hns8.length;
        String[][] hnamevecs = new String[N][];
        for (int s = 0; s != N; ++s) {
            char[] HNS8_VEC = hns8[s].toCharArray();
            int N_CH = HNS8_VEC.length;
            String[] hnames = new String[N_CH];
            for (int i = 0; i != N_CH; ++i) {
                hnames[i] = hnmmap.hamName(HNS8_VEC[i]);
            }
            hnamevecs[s] = hnames;
        }
        return hnamevecs;
    }

    public static String[] hns8FromHNSU(String[] hnsu) {
        HNSOctetUCSMap hu8map = HNSOctetUCSMap.getHNSMapOctetAllUCS();
        int N = hnsu.length;
        String[] hns8 = new String[N];
        for (int i = 0; i != N; ++i) {
            hns8[i] = hu8map.hns8(hnsu[i]);
        }
        return hns8;
    }

    public static String[] cleanHNS8(String[] hns8) {
        HNSOctetUCSMap h8umap = HNSOctetUCSMap.getHNSMapOctetAllUCS();
        int N = hns8.length;
        for (int i = 0; i != N; ++i) {
            hns8[i] = h8umap.cleanHNS8(hns8[i], i);
        }
        return hns8;
    }

    public static String[] cleanHNSU(String[] hnsu) {
        HNSOctetUCSMap h8umap = HNSOctetUCSMap.getHNSMapOctetAllUCS();
        int N = hnsu.length;
        for (int i = 0; i != N; ++i) {
            hnsu[i] = h8umap.cleanHNSU(hnsu[i], i);
        }
        return hnsu;
    }

    public static String[][] cleanHamNameVecs(String[][] hamnvs) {
        HamNameMap hnmmap = HamNameMap.getStdHamNameMap();
        int N = hamnvs.length;
        for (int i = 0; i != N; ++i) {
            hamnvs[i] = hnmmap.cleanHamNameVec(hamnvs[i], i);
        }
        return hamnvs;
    }

    public static String[] hnsuFromHNS8(String[] hns8) {
        HNSOctetUCSMap hu8map = HNSOctetUCSMap.getHNSMapOctetAllUCS();
        int N = hns8.length;
        String[] hnsu = new String[N];
        for (int i = 0; i != N; ++i) {
            hnsu[i] = hu8map.ucs(hns8[i]);
        }
        return hnsu;
    }

    public static String[] hnsFromHNSItems(String[] hnsitems) {
        int N = hnsitems.length;
        String[] hns = new String[N];
        for (int i = 0; i != N; ++i) {
            String[] hparts = hnsitems[i].split("[\\t]");
            hns[i] = hparts[0].trim();
        }
        return hns;
    }

    public static String[] tailsFromHNSItems(String[] hnsitems) {
        int N = hnsitems.length;
        String[] tails = new String[N];
        for (int i = 0; i != N; ++i) {
            String[] hparts = hnsitems[i].split("[\\t]");
            int HNS_LEN = hparts[0].length();
            tails[i] = hnsitems[i].substring(HNS_LEN);
        }
        return tails;
    }

    public static String[] glossesFromHNSItems(String[] hnsitems) {
        int N = hnsitems.length;
        String[] glosses = new String[N];
        for (int i = 0; i != N; ++i) {
            String[] hparts = hnsitems[i].split("[\\t]");
            glosses[i] = 2 <= hparts.length ? hparts[1] : HNSUtils.glossForItem(i, N);
        }
        return glosses;
    }

    public static String[] hnsSignFromHNSNameVec(String[] hnsnv, String gloss) {
        return HNSUtils.EL_WRAP(HNS_SIGN, GLOSS, gloss, HNSUtils.hnsManElFromHNSNameVec(hnsnv));
    }

    public static String[] hnsManElFromHNSNameVec(String[] hnsnv) {
        int N = hnsnv.length;
        String[] manels = new String[N];
        for (int i = 0; i != N; ++i) {
            manels[i] = HNSUtils.EL_EMPTY(hnsnv[i]);
        }
        return HNSUtils.EL_WRAP(HNS_MANUAL, manels);
    }

    public static String[] hnsuItemsFromHSiGML(String[] hslines) {
        String[][] hsigns = HNSUtils.elSeqFromSimpleXML(HNS_SIGN, hslines);
        int N = hsigns.length;
        String[][] hmans = HNSUtils.hnsMansFromHNSSigns(hsigns);
        String[] hnsu = HNSUtils.hnsuFromHNSMans(hmans);
        String[] glosses = HNSUtils.glossesFromSigns(hsigns);
        for (int i = 0; i != N; ++i) {
            glosses[i] = "\t" + glosses[i];
        }
        String[] hnsui = HNSUtils.zip(hnsu, glosses);
        return hnsui;
    }

    public static String[] hnsuFromHNSMans(String[][] hmans) {
        String[][] hnsnv = HNSUtils.hnsNameVecsFromHNSMans(hmans);
        return HNSUtils.hnsuFromHNSNameVecs(HNSUtils.cleanHamNameVecs(hnsnv));
    }

    public static String[][] hnsNameVecsFromHNSMans(String[][] hmans) {
        int N = hmans.length;
        String[][] hnvecs = new String[N][];
        for (int i = 0; i != N; ++i) {
            String[] H_MAN = hmans[i];
            int NM = H_MAN.length;
            if (2 <= NM) {
                ArrayList<String> HN_LIST = new ArrayList<String>(NM - 2);
                for (int k = 1; k != NM - 1; ++k) {
                    String HN = HNSUtils.elNameFromEmptyEl(H_MAN[k].trim());
                    if (HN == null) continue;
                    HN_LIST.add(HN);
                }
                int N_HN = HN_LIST.size();
                hnvecs[i] = new String[N_HN];
                HN_LIST.toArray(hnvecs[i]);
                continue;
            }
            hnvecs[i] = new String[0];
        }
        return hnvecs;
    }

    public static String[] glossesFromSigns(String[][] signs) {
        String GLOSS_START = "gloss=\"";
        int GS_LEN = "gloss=\"".length();
        int N = signs.length;
        String[] glosses = new String[N];
        for (int i = 0; i != N; ++i) {
            int gg;
            int g;
            String gloss = null;
            String HS_TAG_LN = signs[i][0];
            int j = HS_TAG_LN.indexOf("gloss=\"");
            if (0 <= j && (g = j + GS_LEN) < (gg = HS_TAG_LN.indexOf(34, g))) {
                gloss = HS_TAG_LN.substring(g, gg);
            }
            glosses[i] = HNSUtils.glossForItem(gloss, i, N);
        }
        return glosses;
    }

    public static String[][] hnsMansFromHNSSigns(String[][] hsigns) {
        int NS = hsigns.length;
        ArrayList<String[]> mlist = new ArrayList<String[]>(NS);
        for (String[] sign : hsigns) {
            String[] man = HNSUtils.singleElFromSimpleXML(HNS_MANUAL, sign);
            if (man == null) continue;
            mlist.add(man);
        }
        int NM = mlist.size();
        String[][] mans = new String[NM][];
        mlist.toArray((T[])mans);
        return mans;
    }

    public static String glossForItem(int ix, int max) {
        return HNSUtils.glossForItem(null, ix, max);
    }

    public static String glossForItem(String gstr, int ix, int max) {
        return gstr != null ? gstr : "item_" + HNSUtils.numStr(ix, max);
    }

    public static String[][] elSeqFromSimpleXML(String el, String[] xlines) {
        String[] els = new String[]{el};
        return HNSUtils.elSeqFromSimpleXML(els, xlines);
    }

    public static void main(String[] args) {
        String[][] elseq;
        String[] xlns = new String[]{"<thing>", "<this>", "<stuff>", "<this/>", "</stuff>", "<that/>", "</this>", "<stuff>", "  <stiff>", "    <stuff>", "    </stuff>", "  </stiff>", "</stuff>", "</thing>"};
        String[] els = new String[]{"that", "stiff"};
        for (String[] el : elseq = HNSUtils.elSeqFromSimpleXML(els, xlns)) {
            System.out.println("----------------");
            for (String ln : el) {
                System.out.println(ln);
            }
        }
        System.out.println("----------------");
    }

    public static String[][] elSeqFromSimpleXML(String[] els, String[] xlines) {
        ArrayList<String[]> elist = new ArrayList<String[]>();
        String EMPTY_END = "/>";
        int N = xlines.length;
        LinkedList<String> elstack = new LinkedList<String>();
        String elend = null;
        int elo = -1;
        int ehi = -1;
        for (int i = 0; i != N; ++i) {
            String xln = xlines[i].trim();
            String el = HNSUtils.elBeginTest(els, xln);
            if (el != null) {
                if (xln.endsWith("/>")) {
                    if (elstack.isEmpty()) {
                        elo = i;
                        ehi = i + 1;
                    }
                } else {
                    if (elstack.isEmpty()) {
                        elo = i;
                    }
                    elend = HNSUtils.EL_END(el);
                    elstack.push(elend);
                }
            } else if (elend != null && xln.equals(elend)) {
                elstack.pop();
                if (!elstack.isEmpty()) {
                    elend = (String)elstack.peekFirst();
                } else {
                    elend = null;
                    ehi = i + 1;
                }
            }
            if (0 > ehi) continue;
            int NE = ehi - elo;
            String[] elns = new String[NE];
            for (int j = 0; j != NE; ++j) {
                elns[j] = xlines[elo + j];
            }
            elist.add(elns);
            ehi = -1;
            elo = -1;
        }
        if (!elstack.isEmpty()) {
            System.err.println("HNSUtils.elSeqFromSimpleXML(): incomplete element: " + HNSUtils.UN_EL_END((String)elstack.peekFirst()));
        }
        int N_EL = elist.size();
        String[][] evecs = new String[N_EL][];
        elist.toArray((T[])evecs);
        return evecs;
    }

    private static String elBeginTest(String[] els, String xln) {
        int N = els.length;
        int i = 0;
        int ii = N;
        while (i != ii) {
            if (xln.startsWith("<" + els[i])) {
                ii = i;
                continue;
            }
            ++i;
        }
        return i != N ? els[i] : null;
    }

    public static String[] singleElFromSimpleXML(String el, String[] xlines) {
        String EMPTY_END = "/>";
        String EL_START = "<" + el;
        String EL_END_TAG = HNSUtils.EL_END(el);
        int N = xlines.length;
        int elo = -1;
        int ehi = -1;
        int i = 0;
        int ii = N;
        String xln = null;
        while (i != ii) {
            xln = xlines[i].trim();
            if (xln.startsWith(EL_START)) {
                ii = i;
                continue;
            }
            ++i;
        }
        if (i != N) {
            elo = i++;
            if (!xln.endsWith("/>")) {
                while (i != ii) {
                    xln = xlines[i].trim();
                    if (xln.equals(EL_END_TAG)) {
                        ii = i;
                        continue;
                    }
                    ++i;
                }
            }
            if (i != N) {
                ehi = i + 1;
            }
        }
        String[] elns = null;
        if (elo < ehi) {
            int NE = ehi - elo;
            elns = new String[NE];
            for (int j = 0; j != NE; ++j) {
                elns[j] = xlines[elo + j];
            }
        }
        return elns;
    }

    public static String[] readLines(BufferedReader brdr) throws IOException {
        ArrayList<String> lns = new ArrayList<String>();
        String ln = brdr.readLine();
        while (ln != null) {
            lns.add(ln);
            ln = brdr.readLine();
        }
        int N = lns.size();
        String[] strs = new String[N];
        lns.toArray(strs);
        return strs;
    }

    public static BufferedReader getBufReader(File dir, String file) {
        return HNSUtils.getBufReader(new File(dir, file));
    }

    public static BufferedReader getBufReader(String path) {
        return HNSUtils.getBufReader(new File(path));
    }

    public static BufferedReader getBufReader(File path) {
        BufferedReader brdr = null;
        try {
            brdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), STD_ENCODING));
        }
        catch (IOException iox) {
            System.err.println(iox);
            System.exit(1);
        }
        return brdr;
    }

    public static BufferedReader getStdBufReader() {
        BufferedReader brdr = null;
        try {
            brdr = new BufferedReader(new InputStreamReader(System.in, STD_ENCODING));
        }
        catch (IOException iox) {
            System.err.println(iox);
            System.exit(1);
        }
        return brdr;
    }

    public static String elNameFromEmptyEl(String eel) {
        String ename = null;
        int N = eel.length();
        if (eel.startsWith("<") && eel.endsWith("/>")) {
            String eelx = eel.replaceFirst("\\s+", "/>");
            int I_END = eelx.indexOf("/>");
            ename = eelx.substring(1, I_END);
        }
        return ename;
    }

    public static final String[] EL_WRAP(String eltype, String anm0, String aval0, String anm1, String aval1, String[] body) {
        String ELSTARTTAG = HNSUtils.EL_START(eltype, anm0, aval0, anm1, aval1);
        return HNSUtils.wrap(ELSTARTTAG, body, HNSUtils.EL_END(eltype));
    }

    public static final String[] EL_WRAP(String eltype, String anm, String aval, String[] body) {
        return HNSUtils.wrap(HNSUtils.EL_START(eltype, anm, aval), body, HNSUtils.EL_END(eltype));
    }

    public static final String[] EL_WRAP(String eltype, String[] body) {
        return HNSUtils.wrap(HNSUtils.EL_START(eltype), body, HNSUtils.EL_END(eltype));
    }

    public static final String XML_DECL(String enc) {
        return "<?xml version=\"1.0\" encoding=\"" + enc + "\"?>";
    }

    public static final String EL_START(String eltype) {
        return "<" + eltype + ">";
    }

    public static final String EL_START(String eltype, String anm0, String aval0, String anm1, String aval1) {
        return "<" + eltype + HNSUtils.ATTR_DEF(anm0, aval0) + HNSUtils.ATTR_DEF(anm1, aval1) + ">";
    }

    public static final String EL_START(String eltype, String anm, String aval) {
        return "<" + eltype + HNSUtils.ATTR_DEF(anm, aval) + ">";
    }

    public static final String EL_END(String eltype) {
        return "</" + eltype + ">";
    }

    public static final String UN_EL_END(String elendtag) {
        int N = elendtag.length();
        return elendtag.substring(2, N - 1);
    }

    public static final String EL_EMPTY(String eltype) {
        return "<" + eltype + " />";
    }

    public static final String EL_EMPTY(String eltype, String anm, String aval) {
        return "<" + eltype + HNSUtils.ATTR_DEF(anm, aval) + " />";
    }

    public static final String ATTR_DEF(String nm, String val) {
        return " " + nm + "=" + "\"" + val + "\"";
    }

    public static void print(String[] lines, PrintWriter prntr) {
        for (String ln : lines) {
            prntr.println(ln);
        }
    }

    public static void toStdOut(String[] lines) {
        HNSUtils.toStream(lines, System.out);
    }

    public static void toStream(String[] lines, PrintStream outs) {
        for (String ln : lines) {
            try {
                outs.write(HNSUtils.bytes(ln));
            }
            catch (IOException iox) {
                System.err.println("toStream(): " + iox);
            }
            outs.println();
        }
        outs.flush();
    }

    public static byte[] bytes(String s) {
        return HNSUtils.bytes(s, STD_ENCODING);
    }

    public static byte[] bytes(String s, String enc) {
        byte[] bb = null;
        try {
            bb = s.getBytes(enc);
        }
        catch (UnsupportedEncodingException uex) {
            bb = s.getBytes();
            System.err.println("Bad encoding " + enc + ": " + uex);
        }
        return bb;
    }

    public static PrintStream filePrintStream(String dir, String fname) throws IOException {
        return HNSUtils.filePrintStream(dir, fname, STD_ENCODING);
    }

    public static PrintStream filePrintStream(String dir, String fname, String enc) throws IOException {
        return HNSUtils.filePrintStream(new File(dir), fname, enc);
    }

    public static PrintStream filePrintStream(File dir, String fname) throws IOException {
        return HNSUtils.filePrintStream(dir, fname, STD_ENCODING);
    }

    public static PrintStream filePrintStream(File dir, String fname, String enc) throws IOException {
        File psfile = new File(dir, fname);
        return new PrintStream(psfile, enc);
    }

    public static String[] wrap(String beg, String[] body, String end) {
        int N = body.length;
        String[] wseq = new String[N + 2];
        wseq[0] = beg;
        wseq[N + 1] = end;
        for (int i = 0; i != N; ++i) {
            wseq[i + 1] = body[i];
        }
        return wseq;
    }

    public static String[] prefix(String pfx, String[] body) {
        int N = body.length;
        String[] pseq = new String[N + 1];
        pseq[0] = pfx;
        for (int i = 0; i != N; ++i) {
            pseq[i + 1] = body[i];
        }
        return pseq;
    }

    public static final String INDENT(int in) {
        return SPACES.substring(0, 2 * in);
    }

    public static String[] indentXML(String[] lines) {
        int N = lines.length;
        int in = 0;
        for (int i = 0; i != N; ++i) {
            String LN = lines[i].trim();
            if (LN.startsWith("</")) {
                --in;
            }
            lines[i] = HNSUtils.INDENT(in) + lines[i];
            if (LN.startsWith("</") || LN.startsWith("<!--") || LN.startsWith("<?") || LN.endsWith("/>") || LN.endsWith("?>") || LN.endsWith("-->") || !LN.endsWith(">")) continue;
            ++in;
        }
        return lines;
    }

    public static String[] zip(String[] ss0, String[] ss1) {
        int N = ss0.length;
        String[] sszip = new String[N];
        for (int i = 0; i != N; ++i) {
            sszip[i] = ss0[i] + ss1[i];
        }
        return sszip;
    }

    public static String[] merge(String[][] slists) {
        ArrayList<String> alist = new ArrayList<String>();
        String[][] arr$ = slists;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] list;
            for (String s : list = arr$[i$]) {
                alist.add(s);
            }
        }
        int N = alist.size();
        String[] strs = new String[N];
        alist.toArray(strs);
        return strs;
    }

    public static String joinLines(String[] lines) {
        return HNSUtils.join(lines, EOL, true);
    }

    public static String join(String[] sseq, String sep) {
        return HNSUtils.join(sseq, sep, false);
    }

    public static String join(String[] sseq, String sep, boolean treat_sep_as_term) {
        String pfx = "";
        StringBuilder buf = new StringBuilder(sseq.length * 20);
        for (String sym : sseq) {
            buf.append(pfx).append(sym);
            pfx = sep;
        }
        if (treat_sep_as_term) {
            buf.append(pfx);
        }
        return buf.toString();
    }

    public static String joinLines(List<String> items) {
        return HNSUtils.join(items, EOL, true);
    }

    public static String join(List<String> sseq, String sep) {
        return HNSUtils.join(sseq, sep, false);
    }

    public static String join(List<String> sseq, String sep, boolean treat_sep_as_term) {
        return HNSUtils.join(sseq.toArray(new String[0]), sep, treat_sep_as_term);
    }

    public static String[] trim(String[] sseq) {
        int N = sseq.length;
        for (int i = 0; i != N; ++i) {
            sseq[i] = sseq[i].trim();
        }
        return sseq;
    }

    public static String numStr(int num, int max) {
        return String.format("%0" + HNSUtils.nDigits(max) + "d", num);
    }

    public static int nDigits(int n) {
        int nd = 1;
        int nn = n / 10;
        while (nn != 0) {
            nn /= 10;
            ++nd;
        }
        return nd;
    }
}

