/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import util.ResourceUtils;

public class HNSOctetUCSMap {
    protected static final String HNS_UNUSED = "UNUSED";
    protected static final String HNS_OCTET_UCS_PROPS_FILE = "util/HNSOctetToUnicode.txt";
    private static HNSOctetUCSMap MAP_OCTET_HIGH_UCS = null;
    private static HNSOctetUCSMap MAP_OCTET_ALL_UCS = null;
    public static final int O_NULL = 0;
    public static final int O_LIMIT = 256;
    public static final char U_NULL = '\uffff';
    public static final int O_HAMVERSION40 = 20;
    public static final int O_HAMSPACE = 32;
    protected char[] o2u = new char[256];
    protected HashMap<Character, Integer> u2o;
    protected final char U_HAMVERSION40;
    protected final char U_HAMSPACE;

    public static final HNSOctetUCSMap getHNSMapOctetHighUCS() {
        return HNSOctetUCSMap.getHNSMapOctetUCS(false);
    }

    public static final HNSOctetUCSMap getHNSMapOctetAllUCS() {
        return HNSOctetUCSMap.getHNSMapOctetUCS(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final HNSOctetUCSMap getHNSMapOctetUCS(boolean DO_ALL_UCS) {
        if ((DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS) != null) return DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS;
        Class<HNSOctetUCSMap> clazz = HNSOctetUCSMap.class;
        synchronized (HNSOctetUCSMap.class) {
            if ((DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS) != null) return DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS;
            HNSOctetUCSMap newmap = new HNSOctetUCSMap(HNS_OCTET_UCS_PROPS_FILE, DO_ALL_UCS);
            if (DO_ALL_UCS) {
                MAP_OCTET_ALL_UCS = newmap;
            } else {
                MAP_OCTET_HIGH_UCS = newmap;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS;
        }
    }

    protected HNSOctetUCSMap(String propspath, boolean DO_ALL_UCS) {
        for (int i = 0; i != 256; ++i) {
            this.o2u[i] = 65535;
        }
        int uhamver = 65535;
        int uhamspace = 65535;
        Properties props = ResourceUtils.getProperties(propspath);
        Enumeration<?> pen = props.propertyNames();
        while (pen.hasMoreElements()) {
            String ostr = (String)pen.nextElement();
            int OCT = Integer.decode(ostr);
            int UCS = HNSOctetUCSMap.getFirstPropsInt(props, ostr);
            if (DO_ALL_UCS || 256 <= UCS) {
                this.o2u[OCT] = (char)UCS;
            }
            if (OCT == 20) {
                uhamver = (char)UCS;
            }
            if (OCT != 32) continue;
            uhamspace = (char)UCS;
        }
        this.u2o = new HashMap(512, 0.5f);
        for (int i = 0; i != 256; ++i) {
            if (this.o2u[i] == '\uffff') continue;
            this.u2o.put(new Character(this.o2u[i]), new Integer(i));
        }
        if (uhamver == 65535) {
            throw new IllegalArgumentException("HNSOctetUCSMap: missing UCS hamversion40.");
        }
        if (uhamspace == 65535) {
            throw new IllegalArgumentException("HNSOctetUCSMap: missing UCS hamspace.");
        }
        this.U_HAMVERSION40 = (char)uhamver;
        this.U_HAMSPACE = (char)uhamspace;
    }

    public char ucs(int o) {
        return 0 <= o && o < 256 ? this.o2u[o] : (char)'\uffff';
    }

    public char cleanUCS(int o) {
        return (char)(0 < o && o <= 32 && o != 20 ? 65535 : this.ucs(o));
    }

    public String ucs(byte[] octets) {
        int N = octets.length;
        StringBuilder ubuf = new StringBuilder(N);
        for (int i = 0; i != N; ++i) {
            ubuf.append(this.ucs(HNSOctetUCSMap.unsigned(octets[i])));
        }
        String ustr = ubuf.toString();
        ubuf.setLength(0);
        return ustr;
    }

    public String ucs(String ostr) {
        int N = ostr.length();
        StringBuilder ubuf = new StringBuilder(N);
        for (int i = 0; i != N; ++i) {
            ubuf.append(this.ucs(ostr.charAt(i)));
        }
        String ustr = ubuf.toString();
        ubuf.setLength(0);
        return ustr;
    }

    public int octet(char u) {
        return this.hns8(u);
    }

    public char hns8(char u) {
        Integer oo = this.u2o.get(Character.valueOf(u));
        return oo == null ? (char)'\u0000' : (char)oo.intValue();
    }

    public char cleanHNS8(char u) {
        return u <= this.U_HAMSPACE && u != this.U_HAMVERSION40 ? (char)'\u0000' : this.hns8(u);
    }

    public String hns8(String ustr) {
        int N = ustr.length();
        StringBuilder obuf = new StringBuilder(N);
        for (int i = 0; i != N; ++i) {
            obuf.append(this.hns8(ustr.charAt(i)));
        }
        String ostr = obuf.toString();
        obuf.setLength(0);
        return ostr;
    }

    public String cleanHNSU(String hnsu, int ix) {
        int j;
        String hnsuclean = hnsu;
        char[] hnsua = hnsu.toCharArray();
        int N = hnsua.length;
        int nbad = 0;
        for (j = 0; j != N; ++j) {
            if (this.cleanHNS8(hnsua[j]) != '\u0000') continue;
            ++nbad;
        }
        if (nbad != 0) {
            int NG = N - nbad;
            char[] hnsugd = new char[NG];
            int g = 0;
            j = 0;
            for (char chu : hnsua) {
                if (this.cleanHNS8(chu) != '\u0000') {
                    hnsugd[g] = chu;
                    ++g;
                } else {
                    String CHU_HEX = String.format("%04X", chu);
                    HNSOctetUCSMap.invalidMsg(ix, j, "HNS-UCS character U+" + CHU_HEX);
                }
                ++j;
            }
            hnsuclean = new String(hnsugd);
        }
        return hnsuclean;
    }

    public String cleanHNS8(String hns8, int ix) {
        int j;
        String hns8clean = hns8;
        char[] hns8a = hns8.toCharArray();
        int N = hns8a.length;
        int nbad = 0;
        for (j = 0; j != N; ++j) {
            if (this.cleanUCS(hns8a[j]) != '\uffff') continue;
            ++nbad;
        }
        if (nbad != 0) {
            int NG = N - nbad;
            char[] hns8gd = new char[NG];
            int g = 0;
            j = 0;
            for (char ch8 : hns8a) {
                if (this.cleanUCS(hns8a[j]) != '\uffff') {
                    hns8gd[g] = ch8;
                    ++g;
                } else {
                    HNSOctetUCSMap.invalidMsg(ix, j, "HNS-8 code " + ch8);
                }
                ++j;
            }
            hns8clean = new String(hns8gd);
        }
        return hns8clean;
    }

    protected static int getFirstPropsInt(Properties props, String istr) {
        int val = 65535;
        String valstr = HNSOctetUCSMap.getFirstPropsToken(props, istr);
        if (valstr != null && !valstr.equals(HNS_UNUSED)) {
            try {
                val = Integer.decode(valstr);
            }
            catch (NumberFormatException nfx) {
                // empty catch block
            }
        }
        return val;
    }

    protected static String getFirstPropsToken(Properties props, String istr) {
        String[] ptoks;
        String pfirst = null;
        String pstr = props.getProperty(istr);
        if (pstr != null && (ptoks = pstr.split("[ \\t]+", 2))[0].length() != 0) {
            pfirst = ptoks[0];
        }
        return pfirst;
    }

    private static int unsigned(byte b) {
        return b & 0xFF;
    }

    private static void invalidMsg(int i, int j, String item) {
        String MSG = "In item " + i + ": rejected " + item + " at position " + j + ".";
        System.err.println(MSG);
    }
}

