/*
 * Decompiled with CFR 0.152.
 */
package sigmldoc2signdocs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import util.HNSUtils;
import util.ToSafeASCIIMap;

public class Main {
    public static void main(String[] args) throws IOException {
        block3: {
            String[] glosses;
            String[][] sdocs;
            String PATH;
            block2: {
                PATH = args == null || args.length == 0 ? null : args[0];
                BufferedReader srdr = PATH == null ? HNSUtils.getStdBufReader() : HNSUtils.getBufReader(PATH);
                String[] sigml = HNSUtils.readLines(srdr);
                String[][] signs = HNSUtils.signsFromSiGMLDoc(sigml);
                sdocs = HNSUtils.signDocsFromSigns(signs);
                glosses = HNSUtils.glossesFromSigns(signs);
                if (PATH != null) break block2;
                for (int i = 0; i != sdocs.length; ++i) {
                    System.out.println("--------  " + i + ": " + glosses[i] + "  --------");
                    HNSUtils.toStdOut(HNSUtils.indentXML(sdocs[i]));
                }
                break block3;
            }
            File rdir = Main.resultDir(PATH);
            if (rdir == null) break block3;
            int N = sdocs.length;
            for (int j = 0; j != N; ++j) {
                String SIGN_FILE_NAME = HNSUtils.numStr(j, N) + "_" + Main.cleanForFS(glosses[j]) + ".sigml";
                PrintStream sfstrm = HNSUtils.filePrintStream(rdir, SIGN_FILE_NAME);
                HNSUtils.toStream(HNSUtils.indentXML(sdocs[j]), sfstrm);
                sfstrm.close();
            }
        }
    }

    private static File resultDir(String SIGML_PATH) throws IOException {
        String sname;
        int i;
        String subdir;
        File spf = new File(SIGML_PATH).getCanonicalFile();
        File dir = spf.getParentFile();
        File subdirf = new File(dir, subdir = ((i = (sname = spf.getName()).lastIndexOf(46)) < 0 ? sname : sname.substring(0, i)) + "-signs");
        if (subdirf.exists()) {
            System.err.println("Directory " + subdir + " already exists.");
            subdirf = null;
        } else {
            subdirf.mkdir();
        }
        return subdirf;
    }

    private static String cleanForFS(String name) {
        return ToSafeASCIIMap.getToSafeASCIIMap().safe(name);
    }
}

