/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import util.FileUtils;
import xml.CleanerEntityResolver;
import xml.InvalidXMLException;

public class XmlValidator {
    protected SAXParser validatingParser;
    protected int nErrors;
    protected PrintWriter printer;

    public XmlValidator() throws ParserConfigurationException, SAXException {
        this.setUpParser();
    }

    public XmlValidator(PrintWriter prntr) throws ParserConfigurationException, SAXException {
        this.printer = prntr;
        this.setUpParser();
    }

    protected void setUpParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(true);
        this.validatingParser = spf.newSAXParser();
    }

    public void validate(InputSource ins, CleanerEntityResolver er) throws IOException, SAXException, InvalidXMLException {
        this.nErrors = 0;
        this.validatingParser.parse(ins, (DefaultHandler)new VDefaultHandler(er));
        if (this.nErrors != 0) {
            throw new InvalidXMLException("" + this.nErrors + " SAX parsing error" + (this.nErrors == 1 ? "." : "s."));
        }
    }

    public void validate(InputSource ins) throws IOException, SAXException, InvalidXMLException {
        this.validate(ins, null);
    }

    public void validate(File f, CleanerEntityResolver er) throws IOException, SAXException, InvalidXMLException {
        InputSource ins = FileUtils.fileInputSource(f);
        this.validate(ins, er);
    }

    public void validate(File f) throws IOException, SAXException, InvalidXMLException {
        this.validate(f, null);
    }

    public void validate(String uri, CleanerEntityResolver er) throws IOException, SAXException, InvalidXMLException {
        InputSource ins = new InputSource(uri);
        this.validate(ins, er);
    }

    public void validate(String uri) throws IOException, SAXException, InvalidXMLException {
        this.validate(uri, null);
    }

    protected void doPrint(String s) {
        if (this.printer == null) {
            System.err.print(s);
        } else {
            this.printer.print(s);
            this.printer.flush();
        }
    }

    protected void doPrintLn(String s) {
        if (this.printer == null) {
            System.err.println(s);
        } else {
            this.printer.println(s);
            this.printer.flush();
        }
    }

    public void printSAXParseException(SAXParseException e) {
        this.printSAXParseException(e, "");
    }

    public void printSAXParseException(SAXParseException e, String kind) {
        String systemId = e.getSystemId();
        int lineNum = e.getLineNumber();
        int colNum = e.getColumnNumber();
        if (systemId != null) {
            this.doPrint(systemId);
        }
        if (lineNum >= 0) {
            this.doPrint(", at [" + lineNum + (colNum >= 0 ? "," + colNum : "") + "]");
        }
        if (systemId != null || lineNum >= 0) {
            this.doPrintLn((kind == null ? "" : ", " + kind) + ":");
        }
        this.doPrintLn("  " + e.getMessage());
    }

    protected class VDefaultHandler
    extends DefaultHandler {
        protected CleanerEntityResolver eResolver;

        public VDefaultHandler(CleanerEntityResolver er) {
            this.eResolver = er;
        }

        public void warning(SAXParseException e) throws SAXException {
            XmlValidator.this.printSAXParseException(e, "WARNING");
        }

        public void error(SAXParseException e) throws SAXException {
            ++XmlValidator.this.nErrors;
            XmlValidator.this.printSAXParseException(e, "ERROR");
        }

        public void fatalError(SAXParseException e) throws SAXException {
            XmlValidator.this.printSAXParseException(e, "FATAL ERROR");
            throw e;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputSource src = null;
            if (this.eResolver != null) {
                src = this.eResolver.resolveEntity(publicId, systemId);
            }
            return src;
        }
    }
}

