/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import util.StringUtils;

public class XmlElementTextGen {
    protected static final String INDENT_STR = "  ";
    protected static final int INDENT_UNIT = "  ".length();
    protected static final String DOUBLE_EOL = StringUtils.EOL + StringUtils.EOL;
    protected static final int EOL_LEN = StringUtils.EOL.length();
    protected static final int DOUBLE_EOL_LEN = EOL_LEN + EOL_LEN;
    protected static final String STD_ENCODING = "utf-8";
    protected Transformer idXformer;
    protected StringWriter outWriter;
    protected boolean doIndent;

    public XmlElementTextGen(boolean doindent) throws TransformerConfigurationException {
        this(doindent, false);
    }

    public XmlElementTextGen(boolean doindent, boolean doxmldecl) throws TransformerConfigurationException {
        this(doindent, STD_ENCODING, doxmldecl);
    }

    public XmlElementTextGen(boolean doindent, String encoding, boolean doxmldecl) throws TransformerConfigurationException {
        this(doindent, encoding, doxmldecl, 2048);
    }

    public XmlElementTextGen(boolean doindent, String encoding, boolean doxmldecl, int bufsize) throws TransformerConfigurationException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        this.idXformer = tfactory.newTransformer();
        this.idXformer.setOutputProperty("method", "xml");
        this.idXformer.setOutputProperty("omit-xml-declaration", doxmldecl ? "no" : "yes");
        this.idXformer.setOutputProperty("encoding", encoding);
        this.doIndent = doindent;
        this.outWriter = new StringWriter(bufsize);
    }

    public String getText(Element el) throws TransformerException {
        this.outWriter.getBuffer().setLength(0);
        DOMSource src = new DOMSource(el);
        StreamResult rslt = new StreamResult(this.outWriter);
        this.idXformer.transform(src, rslt);
        this.outWriter.flush();
        String txt = this.outWriter.toString();
        if (txt.endsWith(DOUBLE_EOL)) {
            txt = txt.substring(0, txt.length() - EOL_LEN);
        }
        String xmllines = this.doIndent ? XmlElementTextGen.indentedLinesForPureXML(txt) : XmlElementTextGen.linesForPureXML(txt);
        return xmllines;
    }

    public String getText(Element el, String prfx, String sffx) throws TransformerException {
        StringBuffer outbuf = this.outWriter.getBuffer();
        outbuf.setLength(0);
        if (prfx != null) {
            this.outWriter.write(prfx);
        }
        DOMSource src = new DOMSource(el);
        StreamResult rslt = new StreamResult(this.outWriter);
        this.idXformer.transform(src, rslt);
        if (sffx != null) {
            this.outWriter.write(sffx);
        }
        this.outWriter.flush();
        String txt = outbuf.toString();
        return txt;
    }

    public void writeText(Element el, Writer wrtr) throws TransformerException {
        DOMSource src = new DOMSource(el);
        StreamResult rslt = new StreamResult(wrtr);
        this.idXformer.transform(src, rslt);
        try {
            wrtr.flush();
        }
        catch (IOException iox) {
            // empty catch block
        }
    }

    public static String indentedLinesForPureXML(String xml) {
        String[] tags = XmlElementTextGen.tagsForPureXML(xml);
        int N = tags.length;
        StringBuilder sbuf = new StringBuilder(xml.length() + N * 8);
        int curil = 0;
        int futil = 0;
        for (int i = 0; i != N; ++i) {
            String tag = tags[i];
            if (!tag.endsWith("/>")) {
                if (tag.startsWith("</")) {
                    if (0 != curil) {
                        --curil;
                        --futil;
                    }
                } else if (!tag.startsWith("<?") && !tag.startsWith("<!")) {
                    ++futil;
                }
            }
            for (int k = 0; k != curil; ++k) {
                sbuf.append(INDENT_STR);
            }
            sbuf.append(tag).append(StringUtils.EOL);
            curil = futil;
        }
        String result = sbuf.toString();
        sbuf = null;
        return result;
    }

    public static String linesForPureXML(String xml) {
        String[] tags = XmlElementTextGen.tagsForPureXML(xml);
        StringBuilder sbuf = new StringBuilder(xml.length() + tags.length * 3);
        for (String tag : tags) {
            sbuf.append(tag).append(StringUtils.EOL);
        }
        String xlines = sbuf.toString();
        sbuf.setLength(0);
        sbuf = null;
        return xlines;
    }

    private static String[] tagsForPureXML(String xml) {
        String xmlxcmmt = xml;
        if (0 <= xml.indexOf("<!--")) {
            Pattern recmmt = Pattern.compile("<!--([^-]|-[^-])*-->", 32);
            xmlxcmmt = recmmt.matcher(xml).replaceAll("");
        }
        Pattern elpat = Pattern.compile("<[^>]*>");
        Matcher xmatch = elpat.matcher(xmlxcmmt);
        ArrayList<String> tagsal = new ArrayList<String>(xmlxcmmt.length() / 8);
        while (xmatch.find()) {
            tagsal.add(xmatch.group());
        }
        int N = tagsal.size();
        String[] tags = new String[N];
        tagsal.toArray(tags);
        tagsal.clear();
        return tags;
    }
}

