/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import util.ResourceUtils;
import xml.XmlElementTextGen;

public class XMLTransformer {
    protected Transformer xformer;
    protected XmlElementTextGen textGen;

    public XMLTransformer(String xslturi) throws XMLTransformerException {
        String fullxuri = ResourceUtils.getLocalURI(xslturi);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        StreamSource xsrc = new StreamSource(fullxuri);
        try {
            Templates templates = tfactory.newTemplates(xsrc);
            this.xformer = templates.newTransformer();
        }
        catch (TransformerConfigurationException tcx) {
            this.fail("Bad xform URI (" + fullxuri + ")", tcx);
        }
        try {
            this.textGen = new XmlElementTextGen(true);
        }
        catch (TransformerConfigurationException tcx) {
            this.fail("XmlElementTextGen creation fails", tcx);
        }
    }

    public String elText(Element el) throws XMLTransformerException {
        String xmltxt = null;
        try {
            xmltxt = this.textGen.getText(el);
        }
        catch (TransformerException tx) {
            this.fail("XML transform text generation failure", tx);
        }
        return xmltxt;
    }

    public void doTransform(String inf, String outf) throws XMLTransformerException {
        try {
            FileInputStream ins = new FileInputStream(inf);
            FileOutputStream outs = new FileOutputStream(outf);
            StreamSource src = new StreamSource(ins);
            StreamResult rslt = new StreamResult(outs);
            this.doTransform(src, rslt);
        }
        catch (IOException iox) {
            this.fail("Transform I/O error", iox);
        }
    }

    public String doTransform(String srcstr) throws XMLTransformerException {
        StringReader srdr = new StringReader(srcstr);
        InputSource sins = new InputSource(srdr);
        SAXSource src = new SAXSource(sins);
        Element rsltel = this.doTransform(src);
        return this.elText(rsltel);
    }

    public Element doTransform(Element srcel) throws XMLTransformerException {
        DOMSource src = new DOMSource(srcel);
        return this.doTransform(src);
    }

    public Element doTransform(Source src) throws XMLTransformerException {
        DOMResult rslt = new DOMResult();
        this.doTransform(src, rslt);
        Document rdoc = (Document)rslt.getNode();
        Element rsltel = rdoc.getDocumentElement();
        return rsltel;
    }

    public void doTransform(Source src, Result rslt) throws XMLTransformerException {
        try {
            this.xformer.transform(src, rslt);
        }
        catch (TransformerException tx) {
            String msg = "XML transform error";
            this.fail(msg, tx);
        }
    }

    protected void fail(String msg, Exception x) throws XMLTransformerException {
        String fullmsg = msg + ": " + x.getMessage();
        throw new XMLTransformerException(fullmsg);
    }

    public static class XMLTransformerException
    extends Exception {
        public XMLTransformerException(String msg) {
            super(msg);
        }
    }
}

