/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLScanner {
    public static final String SAX_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String SAX_NS_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String SAX_STRING_INTERN = "http://xml.org/sax/features/string-interning";
    protected String inputTag;
    protected SAXParser saxParser;

    public XMLScanner(String intag) throws ScanException {
        this(intag, true);
    }

    public XMLScanner(String intag, boolean validate) throws ScanException {
        this.inputTag = intag;
        this.setUpParser(validate);
    }

    public void scanXML(InputSource insrc, DefaultHandler hndlr) throws ScanException {
        this.runParser(insrc, hndlr);
    }

    public void scanXML(String inuri, DefaultHandler hndlr) throws ScanException {
        this.runParser(inuri, hndlr);
    }

    public void scanXMLText(String txt, DefaultHandler hndlr) throws ScanException {
        StringReader txtrdr = new StringReader(txt);
        InputSource insrc = new InputSource(txtrdr);
        this.runParser(insrc, hndlr);
    }

    public static String getSPXLocationText(SAXParseException spx) {
        String sysid = spx.getSystemId();
        if (sysid == null) {
            sysid = "[unknown]";
        }
        return "(Line.Col)URI=(" + spx.getLineNumber() + "." + spx.getColumnNumber() + ")" + sysid;
    }

    public static String getSPXLineColText(SAXParseException spx) {
        return "(Line.Col)=(" + spx.getLineNumber() + "." + spx.getColumnNumber() + ")";
    }

    protected void setUpParser(boolean validate) throws ScanException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(validate);
        spf.setNamespaceAware(true);
        try {
            spf.setFeature(SAX_NAMESPACES, true);
            spf.setFeature(SAX_NS_PREFIXES, false);
            spf.setFeature(SAX_STRING_INTERN, true);
            this.saxParser = spf.newSAXParser();
        }
        catch (SAXNotRecognizedException nrx) {
            this.abort(nrx.toString());
        }
        catch (SAXNotSupportedException nsx) {
            this.abort(nsx.toString());
        }
        catch (ParserConfigurationException pcx) {
            this.abort(pcx.toString());
        }
        catch (SAXException sx) {
            this.abort(sx.toString());
        }
    }

    protected void runParser(InputSource insrc, DefaultHandler hndlr) throws ScanException {
        String srcpfx = this.inputTag + " " + insrc.getSystemId();
        try {
            this.saxParser.parse(insrc, hndlr);
        }
        catch (SAXParseException spx) {
            this.abort(srcpfx + " " + XMLScanner.getSPXLineColText(spx) + ": " + spx.getMessage());
        }
        catch (SAXException sx) {
            this.abort(srcpfx + ": " + sx.getMessage());
        }
        catch (IOException iox) {
            this.abort(srcpfx + ": " + iox.getMessage());
        }
    }

    protected void runParser(String inuri, DefaultHandler hndlr) throws ScanException {
        String srcpfx = this.inputTag + " " + inuri;
        try {
            this.saxParser.parse(inuri, hndlr);
        }
        catch (SAXParseException spx) {
            this.abort(srcpfx + " " + XMLScanner.getSPXLineColText(spx) + ": " + spx.getMessage());
        }
        catch (SAXException sx) {
            this.abort(srcpfx + ": " + sx.getMessage());
        }
        catch (IOException iox) {
            this.abort(srcpfx + ": " + iox.getMessage());
        }
    }

    protected void abort(String msg) throws ScanException {
        throw new ScanException(msg);
    }

    public static class ScanException
    extends Exception {
        public ScanException(String msg) {
            super(msg);
        }
    }
}

