/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xml.CleanerEntityResolver;
import xml.XmlElementTextGen;

public class XMLChildElementsExtractor {
    protected final String xmlDocText;
    protected final String[] wantedElements;
    protected final String onlyWantedElement;
    protected final boolean doValidate;
    protected final CleanerEntityResolver resolver;
    protected String[] extractedElements;

    public XMLChildElementsExtractor(String xmldoc, String elnm, CleanerEntityResolver rslvr) {
        this(xmldoc, elnm, true, rslvr);
    }

    public XMLChildElementsExtractor(String xmldoc, String elnm, boolean validate, CleanerEntityResolver rslvr) {
        this(xmldoc, elnm, null, validate, rslvr);
    }

    public XMLChildElementsExtractor(String xmldoc, String[] elnames, CleanerEntityResolver rslvr) {
        this(xmldoc, elnames, true, rslvr);
    }

    public XMLChildElementsExtractor(String xmldoc, String[] elnames, boolean validate, CleanerEntityResolver rslvr) {
        this(xmldoc, null, elnames, validate, rslvr);
    }

    private XMLChildElementsExtractor(String xmldoc, String elname, String[] elnames, boolean validate, CleanerEntityResolver rslvr) {
        this.xmlDocText = XMLChildElementsExtractor.stripInitBOM(xmldoc);
        this.onlyWantedElement = elname;
        this.wantedElements = elnames;
        this.doValidate = validate;
        this.resolver = rslvr;
        this.extractedElements = new String[0];
        this.extractWantedElements();
    }

    public String[] getElementStrings() {
        return this.extractedElements;
    }

    protected void extractWantedElements() {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            dbfactory.setIgnoringComments(true);
            dbfactory.setValidating(this.doValidate);
            DocumentBuilder db = dbfactory.newDocumentBuilder();
            db.setEntityResolver(this.resolver);
            InputSource source = new InputSource(new StringReader(this.xmlDocText));
            Document doc = db.parse(source);
            XmlElementTextGen xmltxtgen = new XmlElementTextGen(false, false);
            NodeList children = doc.getDocumentElement().getChildNodes();
            int NC = children.getLength();
            ArrayList<String> wlist = new ArrayList<String>(NC);
            for (int c = 0; c != NC; ++c) {
                Node CHILD = children.item(c);
                if (CHILD.getNodeType() != 1 || !this.isWantedElement(CHILD.getNodeName())) continue;
                wlist.add(xmltxtgen.getText((Element)CHILD));
            }
            int N_WANTED = wlist.size();
            if (N_WANTED != 0) {
                this.extractedElements = new String[N_WANTED];
                wlist.toArray(this.extractedElements);
            }
        }
        catch (SAXException sx) {
            sx.printStackTrace();
        }
        catch (ParserConfigurationException pcx) {
            pcx.printStackTrace();
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        catch (TransformerConfigurationException tcx) {
            tcx.printStackTrace();
        }
        catch (TransformerException tx) {
            tx.printStackTrace();
        }
    }

    protected boolean isWantedElement(String eltag) {
        return this.onlyWantedElement != null ? eltag.equals(this.onlyWantedElement) : 0 <= this.wantedElementIndex(eltag);
    }

    protected int wantedElementIndex(String eltag) {
        int N_EN = this.wantedElements.length;
        int i = 0;
        int ii = N_EN;
        while (i != ii) {
            if (eltag.equals(this.wantedElements[i])) {
                ii = i;
                continue;
            }
            ++i;
        }
        return i == N_EN ? -1 : i;
    }

    protected static String stripInitBOM(String s) {
        char ch0 = s.charAt(0);
        return ch0 == '\ufeff' || ch0 == '\ufffe' ? s.substring(1) : s;
    }

    protected static String[] singleton(String s) {
        String[] onestr = new String[]{s};
        return onestr;
    }
}

