/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.BytesEncodingChecker;
import util.InputStreamAsBytes;

public class XMLBytesDecoder {
    private static final String ENC_DECL_SINGLE_QUOTE = "encoding\\s*=\\s*'([^']+)'";
    private static final String ENC_DECL_DOUBLE_QUOTE = "encoding\\s*=\\s*\"([^\"]+)\"";
    private static final String XML_DECL_BEGIN = "<?xml";
    private static final String XML_DECL_END = "?>";
    private static final String XML_DECL = "<\\?xml[^\\?]*\\?>";
    private static final Pattern XML_DECL_PATTERN = Pattern.compile("<\\?xml[^\\?]*\\?>");
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String ISO_ENCODING = "ISO-8859-1";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    private byte[] bytes;
    private String result;
    private boolean explicitEncChecked;
    private String explicitEnc;
    private BytesEncodingChecker encChecker;
    private String defaultEncoding;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: java -cp ... xml.XMLBytesDecoder path");
        } else {
            FileInputStream fins = new FileInputStream(args[0]);
            InputStreamAsBytes inb = new InputStreamAsBytes(fins);
            XMLBytesDecoder xbd = new XMLBytesDecoder(inb.getBytes());
            System.out.println("########  XML:  ########");
            System.out.print(xbd.getXMLString());
            System.out.println("########  (End XML)  ########");
        }
    }

    public XMLBytesDecoder(byte[] inb) throws IOException {
        this(inb, "UTF-8");
    }

    public XMLBytesDecoder(byte[] inb, String dfltenc) throws IOException {
        this.bytes = inb;
        this.defaultEncoding = dfltenc;
        this.explicitEncChecked = false;
        this.explicitEnc = null;
        this.encChecker = new BytesEncodingChecker(this.bytes);
        String NON_XML_ENC = this.encChecker.encodingIsKnown16Bit() ? this.encChecker.encodingForUCS16() : (this.encChecker.encodingIsKnownUTF8() ? "UTF-8" : null);
        System.out.println("####  Basic byte-level encoding: " + (NON_XML_ENC != null ? NON_XML_ENC : "NONE"));
        if (NON_XML_ENC == null) {
            this.checkFor8BitXMLEncoding();
        }
        String ENC = NON_XML_ENC != null ? NON_XML_ENC : (this.explicitEnc != null ? this.explicitEnc : this.defaultEncoding);
        int NSKIP = this.encChecker.countBOMPrefixBytes();
        this.result = this.encChecker.getDecodedString(ENC, NSKIP);
    }

    public String getXMLString() {
        return this.result;
    }

    public String explicitXMLEncoding() {
        if (!this.explicitEncChecked) {
            this.explicitEncChecked = true;
            this.explicitEnc = XMLBytesDecoder.explicitEncoding(this.result);
        }
        return this.explicitEnc;
    }

    protected void checkFor8BitXMLEncoding() throws UnsupportedEncodingException {
        String s5;
        byte[] thebytes = this.bytes;
        int N = thebytes.length;
        if (5 <= N && (s5 = new String(thebytes, 0, 5, ISO_ENCODING)).equals(XML_DECL_BEGIN)) {
            int i = 4;
            int ii = N - 1;
            while (i != ii) {
                if (thebytes[i] == 63 && thebytes[i + 1] == 62) {
                    ii = i;
                    continue;
                }
                ++i;
            }
            if (i != N - 1) {
                String THE_XML_DECL = new String(thebytes, 0, i + 2, ISO_ENCODING);
                this.explicitEnc = XMLBytesDecoder.xmlDeclEncoding(THE_XML_DECL);
            }
        }
        this.explicitEncChecked = true;
    }

    public static String explicitEncoding(String xml) {
        Matcher xdmatcher = XML_DECL_PATTERN.matcher(xml);
        return xdmatcher.lookingAt() ? XMLBytesDecoder.xmlDeclEncoding(xdmatcher.group()) : null;
    }

    protected static String xmlDeclEncoding(String xmldecl) {
        return XMLBytesDecoder.xmlDeclEncoding(xmldecl, null);
    }

    protected static String xmlDeclEncoding(String xmldecl, String dfltenc) {
        String enc = null;
        Matcher encmatcher = Pattern.compile(ENC_DECL_DOUBLE_QUOTE).matcher(xmldecl);
        if (encmatcher.find()) {
            enc = encmatcher.group(1);
        } else {
            encmatcher = Pattern.compile(ENC_DECL_SINGLE_QUOTE).matcher(xmldecl);
            if (encmatcher.find()) {
                enc = encmatcher.group(1);
            }
        }
        if (enc != null) {
            System.out.println("####  XML-declared-encoding=" + enc);
        }
        return enc == null ? dfltenc : enc;
    }
}

