/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenizedLinesReader {
    protected BufferedReader theReader;
    protected Pattern delimCharsPattern;
    protected ArrayList<String> tokensCache;

    public TokenizedLinesReader(Reader rdr, String delimsre) {
        this.theReader = new BufferedReader(rdr);
        this.delimCharsPattern = Pattern.compile(delimsre);
        this.tokensCache = new ArrayList(24);
    }

    public String[] getLineAsTokens() {
        String line = null;
        try {
            line = this.theReader.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] toks = null;
        if (line != null) {
            this.tokensCache.clear();
            Matcher dmatcher = this.delimCharsPattern.matcher(line);
            int isym = 0;
            while (dmatcher.find()) {
                int I_DELIM = dmatcher.start();
                if (isym < I_DELIM) {
                    this.tokensCache.add(line.substring(isym, I_DELIM));
                }
                isym = dmatcher.end();
                for (char dch : dmatcher.group().toCharArray()) {
                    this.tokensCache.add(Character.toString(dch));
                }
            }
            if (isym < line.length()) {
                this.tokensCache.add(line.substring(isym));
            }
            toks = this.tokensCache.toArray(new String[0]);
            this.tokensCache.clear();
        }
        return toks;
    }
}

