/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;

public class StringUtils {
    public static final String EOL = System.getProperty("line.separator", "\n");

    private StringUtils() {
    }

    public static String intField(int i, int w) {
        int myw = w;
        if (myw < 0) {
            myw = 0;
        }
        String ss = "          ";
        int sslen = "          ".length();
        StringBuilder sb = new StringBuilder("          ");
        while (sb.length() < myw) {
            sb.append("          ");
        }
        sb.append(i);
        return sb.substring(sb.length() - myw);
    }

    public static int nnVal(String s, int b, String errmsg) {
        int i = -1;
        try {
            i = Integer.parseInt(s, b);
        }
        catch (NumberFormatException nfx) {
            if (errmsg != null) {
                System.out.println(errmsg);
            }
            nfx.printStackTrace();
        }
        return i;
    }

    public static int nnVal(String s, String errmsg) {
        return StringUtils.nnVal(s, 10, errmsg);
    }

    public static int iVal(String s, String errmsg) {
        int i = 0;
        try {
            i = Integer.decode(s);
        }
        catch (NumberFormatException nfx) {
            if (errmsg != null) {
                System.out.println(errmsg);
            }
            nfx.printStackTrace();
        }
        return i;
    }

    public static int nnProp(String s, String ptag) {
        int j;
        int i = s.indexOf(ptag + "=");
        int k = j = i + ptag.length() + 1;
        int t = s.length();
        while (k != t) {
            if (Character.isDigit(s.charAt(k))) {
                ++k;
                continue;
            }
            t = k;
        }
        String valstr = s.substring(j, k);
        int val = -1;
        try {
            val = Integer.decode(valstr);
        }
        catch (NumberFormatException nfx) {
            // empty catch block
        }
        return val;
    }

    public static String[] linesToStrings(String lns) {
        return StringUtils.linesToStrings(lns, false);
    }

    public static String[] linesToAllStrings(String lns) {
        return StringUtils.linesToStrings(lns, true);
    }

    protected static String[] linesToStrings(String lns, boolean keepblanks) {
        ArrayList<String> al = new ArrayList<String>(100);
        try {
            StringReader rdr = new StringReader(lns);
            BufferedReader brdr = new BufferedReader(rdr);
            String ln = brdr.readLine();
            while (ln != null) {
                if (keepblanks || !ln.equals("")) {
                    al.add(ln);
                }
                ln = brdr.readLine();
            }
        }
        catch (IOException iox) {
            System.err.println(iox.getMessage());
        }
        int N = al.size();
        String[] lnstrs = new String[N];
        al.toArray(lnstrs);
        return lnstrs;
    }

    public static String linesToOneString(String[] lnstrs) {
        return StringUtils.linesToOneString(lnstrs, 40);
    }

    public static String linesToOneString(String[] lnstrs, int estlen) {
        int N = lnstrs.length;
        StringBuilder sbuf = new StringBuilder(N * estlen);
        for (int i = 0; i != N; ++i) {
            sbuf.append(lnstrs[i]).append(EOL);
        }
        return sbuf.toString();
    }

    public static final String readText(InputStream ins) throws IOException {
        String txt = null;
        String[] lns = StringUtils.readLines(ins);
        if (lns != null) {
            txt = StringUtils.linesToOneString(lns);
        }
        return txt;
    }

    public static final String[] readLines(InputStream ins) throws IOException {
        BufferedReader brdr = new BufferedReader(new InputStreamReader(ins));
        ArrayList<String> lines = new ArrayList<String>();
        String ln = brdr.readLine();
        while (ln != null) {
            lines.add(ln);
            ln = brdr.readLine();
        }
        brdr.close();
        ins.close();
        String[] lnstrings = new String[lines.size()];
        lines.toArray(lnstrings);
        lines.clear();
        return lnstrings;
    }
}

