/*
 * Decompiled with CFR 0.152.
 */
package util;

public class SILTimer {
    private long t0;
    private long t1;
    private boolean displayIsDisabled = false;

    public SILTimer() {
        this.start();
    }

    public void setDisplayDisabled(boolean da) {
        this.displayIsDisabled = da;
    }

    public void start() {
        this.t0 = System.nanoTime();
    }

    public long getTimeNow() {
        return System.nanoTime();
    }

    public long startAndGet() {
        this.start();
        return this.t0;
    }

    public float getTimeDeltaMS(long tm0, long tm1) {
        long td = tm1 - tm0;
        return (float)(0.001 * (double)((int)((double)td * 0.001)));
    }

    public float getTimeMS() {
        this.t1 = System.nanoTime();
        return this.getTimeDeltaMS(this.t0, this.t1);
    }

    public float getRelativeTimeMS(long tbase) {
        long tnow = System.nanoTime();
        return this.getTimeDeltaMS(tbase, tnow);
    }

    public void showGivenTimeMS(float tms, String tag) {
        if (!this.displayIsDisabled) {
            System.out.printf(tag + "=%6.3f ms.\n", Float.valueOf(tms));
        }
    }

    public void showTimeMS(String tag) {
        this.showGivenTimeMS(this.getTimeMS(), tag);
    }

    public void showTimeMSAndRestart(String tag) {
        this.showGivenTimeMS(this.getTimeMS(), tag);
        this.t0 = this.t1;
    }

    public void showRelativeTimeMS(long tbase, String tag) {
        float tms = this.getRelativeTimeMS(tbase);
        this.showGivenTimeMS(tms, tag);
    }

    public float getAndShowTimeMS(String tag) {
        float tms = this.getTimeMS();
        this.showGivenTimeMS(tms, tag);
        return tms;
    }

    public float getAndShowRelativeTimeMS(long tbase, String tag) {
        float tms = this.getRelativeTimeMS(tbase);
        this.showGivenTimeMS(tms, tag);
        return tms;
    }
}

