/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class ReaderLinesTracker {
    protected BufferedReader bReader;
    protected ArrayList<String> lines;
    protected Loc lo;
    protected Loc hi;

    public ReaderLinesTracker(Reader rdr) throws IOException {
        this.bReader = new BufferedReader(rdr);
        this.lines = new ArrayList(1024);
        this.lo = new Loc(1, 1);
        this.hi = new Loc(1, 1);
    }

    public ReaderLinesTracker(File f) throws IOException {
        this(new FileReader(f));
    }

    public void close() {
        this.lines.clear();
        try {
            this.bReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int lnBack() {
        return this.lo.ln;
    }

    public int lnFront() {
        return this.hi.ln;
    }

    public void advanceBack(int lnlo, int collo) {
        this.advanceBack(new Loc(lnlo, collo));
    }

    public void advanceFront(int lnhi, int colhi) {
        this.advanceFront(new Loc(lnhi, colhi));
    }

    public int findInLine(int i, String s) {
        String ln = this.line(i);
        int p = ln.indexOf(s);
        if (0 <= p) {
            p += this.base(i);
        }
        return p;
    }

    public String[] segment(int lnlo, int collo, int lnhi, int colhi) {
        int hiadj;
        boolean partialfinal = lnlo == lnhi | 1 != colhi;
        int N = lnhi - lnlo + (partialfinal ? 1 : 0);
        String[] seglns = new String[N];
        for (int i = 0; i != N; ++i) {
            seglns[i] = this.line(lnlo + i);
        }
        int loadj = collo - this.base(lnlo);
        if (0 < loadj) {
            seglns[0] = seglns[0].substring(loadj);
        }
        if (0 < (hiadj = this.base(lnhi) + this.len(lnhi) - colhi)) {
            String lhi = seglns[N - 1];
            seglns[N - 1] = lhi.substring(0, lhi.length() - hiadj);
        }
        return seglns;
    }

    protected void advanceBack(Loc newLo) {
        if (this.hi.isBefore(newLo)) {
            this.advanceFront(newLo);
        }
        while (this.lo.isBeforeLn(newLo)) {
            this.lines.remove(0);
            this.lo.incLn();
        }
        if (this.lo.isBeforeCol(newLo)) {
            this.lo.incCol(newLo.col - this.lo.col);
        }
    }

    protected void advanceFront(Loc newHi) {
        if (this.hi.isBeforeCol(newHi) && 1 != this.hi.col) {
            this.hi.incCol(newHi.col - this.hi.col);
        } else {
            if (1 != this.hi.col) {
                this.hi.incLn();
            }
            while (this.hi.isBeforeLn(newHi)) {
                this.readOneLine();
                this.hi.incLn();
            }
            if (this.hi.isBeforeCol(newHi)) {
                this.readOneLine();
                this.hi.incCol(newHi.col - this.hi.col);
            }
        }
    }

    protected String fullLineText(int ln) {
        return this.lines.get(ln - this.lo.ln);
    }

    protected String line(int ln) {
        String l = null;
        if (ln == this.hi.ln && 1 == this.hi.col) {
            l = "";
        } else {
            int len;
            int adj;
            l = this.fullLineText(ln);
            if (ln == this.lo.ln && 0 < (adj = this.base(ln) - 1)) {
                l = l.substring(adj);
            }
            if (ln == this.hi.ln && (len = this.len(ln)) < l.length()) {
                l = l.substring(0, len);
            }
        }
        return l;
    }

    protected int base(int ln) {
        return ln == this.lo.ln ? this.lo.col : 1;
    }

    protected int len(int ln) {
        return (ln == this.hi.ln ? this.hi.col : 1 + this.fullLineText(ln).length()) - this.base(ln);
    }

    protected void readOneLine() {
        try {
            String ln = this.bReader.readLine();
            this.lines.add(ln);
        }
        catch (IOException iox) {
            String msg = "RLTracker-readLine(): " + iox.getMessage();
            System.out.println(msg);
        }
    }

    protected static class Loc {
        public int ln;
        public int col;

        public Loc(int l, int c) {
            this.ln = l;
            this.col = c;
        }

        public void incLn() {
            ++this.ln;
            this.col = 1;
        }

        public void incCol(int adj) {
            this.col += adj;
        }

        public boolean isBeforeLn(Loc loc) {
            return this.ln < loc.ln;
        }

        public boolean isSameLn(Loc loc) {
            return this.ln == loc.ln;
        }

        public boolean isBeforeCol(Loc loc) {
            return this.isSameLn(loc) && this.col < loc.col;
        }

        public boolean isBefore(Loc loc) {
            return this.isBeforeLn(loc) || this.isBeforeCol(loc);
        }

        public String toString() {
            return "<" + this.ln + "," + this.col + ">";
        }
    }
}

