/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RE {
    public static final String ONE_SPACE = "\\s";
    public static final String ONE_NON_SPACE = "\\S";
    public static final String SPACE_OPT = RE.seq("\\s");
    public static final String NON_SPACE_OPT = RE.seq("\\S");
    public static final String SPACE = RE.seqNE("\\s");
    public static final String NON_SPACE = RE.seqNE("\\S");
    public static final String ONE_TABSP = "[\\t ]";
    public static final String ONE_NON_TABSP = "[^\\t ]";
    public static final String TABSP_OPT = RE.seq("[\\t ]");
    public static final String NON_TABSP_OPT = RE.seq("[^\\t ]");
    public static final String TABSP = RE.seqNE("[\\t ]");
    public static final String NON_TABSP = RE.seqNE("[^\\t ]");
    public static final String WORD = RE.seqNE("[a-zA-Z]");
    public static final String NAME = RE.seqNE("\\w");
    public static final String NON_NEG_INT = RE.seqNE("\\d");
    public static final String SQ_BODY = RE.seq("[^']");
    public static final String DQ_BODY = RE.seq("[^\"]");
    public static final String SQ_STRING = RE.squote(SQ_BODY);
    public static final String DQ_STRING = RE.dquote(DQ_BODY);
    public static final String STRING = RE.or(SQ_STRING, DQ_STRING);
    public static final String EQ = SPACE_OPT + "=" + SPACE_OPT;
    public static final String BOOL = RE.or("true", "false");

    public static final String notChr(String ch) {
        return "[^" + ch + "]";
    }

    public static final String tag(String re) {
        return "(" + re + ")";
    }

    public static final String opt(String re) {
        return re + "?";
    }

    public static final String seq(String re) {
        return re + "*";
    }

    public static final String seqNE(String re) {
        return re + "+";
    }

    public static final String opttag(String re) {
        return RE.opt(RE.tag(re));
    }

    public static final String seqtag(String re) {
        return RE.seq(RE.tag(re));
    }

    public static final String seqNEtag(String re) {
        return RE.seqNE(RE.tag(re));
    }

    public static final String or(String re0, String re1) {
        return re0 + "|" + re1;
    }

    public static final String num(int width) {
        return "\\d{" + width + "}";
    }

    public static final String squote(String re) {
        return "'" + re + "'";
    }

    public static final String dquote(String re) {
        return "\"" + re + "\"";
    }

    public static final String quote(String re) {
        return RE.or(RE.squote(re), RE.dquote(re));
    }

    public static final String quote(String sre, String dre) {
        return RE.or(RE.squote(sre), RE.dquote(dre));
    }

    public static final Matcher matcher(String re, String text) {
        return Pattern.compile(re).matcher(text);
    }

    public static final String extract(String re, String text) {
        String result = null;
        Matcher mtchr = RE.matcher(re, text);
        if (mtchr.matches()) {
            result = mtchr.group(1);
        }
        return result;
    }

    public static final String extractHead(String re, String text) {
        String result = null;
        Matcher mtchr = RE.matcher(re, text);
        if (mtchr.lookingAt()) {
            result = mtchr.group();
        }
        return result;
    }

    public static final String extractTail(String re, String text) {
        String result = null;
        Matcher mtchr = RE.matcher(re, text);
        if (mtchr.lookingAt()) {
            int K = mtchr.group().length();
            result = text.substring(K).trim();
        }
        return result;
    }

    public static final String reAV(String are) {
        return RE.reTaggedAVq(are, STRING);
    }

    public static final String reAV(String are, String vre) {
        return RE.reTaggedAVq(are, RE.quote(vre));
    }

    public static final String reAV(String are, String svre, String dvre) {
        return RE.reTaggedAVq(are, RE.quote(svre, dvre));
    }

    public static final String reTaggedAVq(String are, String qvre) {
        return RE.tag(are) + EQ + RE.tag(qvre);
    }

    public static AV findAVq(String avtext, String are, String qvre) {
        AV av = null;
        String tavre = RE.reTaggedAVq(are, qvre);
        Matcher mtchr = RE.matcher(tavre, avtext);
        if (mtchr.find()) {
            av = new AV();
            av.attr = mtchr.group(1);
            String qattr = mtchr.group(2);
            av.val = qattr.substring(1, qattr.length() - 1);
        }
        return av;
    }

    public static AV getAVq(String avtext, String are, String qvre) {
        AV av = null;
        String avre = RE.reTaggedAVq(are, qvre);
        Matcher mtchr = RE.matcher(avre, avtext);
        if (mtchr.matches()) {
            av = new AV();
            av.attr = mtchr.group(1);
            String qattr = mtchr.group(2);
            av.val = qattr.substring(1, qattr.length() - 1);
        }
        return av;
    }

    public static AV getAV(String avtext, String are, String vre) {
        return RE.getAVq(avtext, are, RE.quote(vre));
    }

    public static AV getWordAV(String avtext) {
        return RE.getAVq(avtext, WORD, STRING);
    }

    public static AV getNameAV(String avtext) {
        return RE.getAVq(avtext, NAME, STRING);
    }

    public static AV getAVBool(String avtext, String are) {
        return RE.getAV(avtext, are, BOOL);
    }

    public static boolean boolResult(AV av, boolean bdefault) {
        boolean b = bdefault;
        if (av != null) {
            b = av.val.equals("true");
        }
        return b;
    }

    public static boolean boolResult(AV av) {
        return RE.boolResult(av, false);
    }

    public static AV getAVInt(String avtext, String are) {
        return RE.getAV(avtext, are, NON_NEG_INT);
    }

    public static int intResult(AV av) {
        int i = -1;
        if (av != null) {
            i = Integer.parseInt(av.val, 10);
        }
        return i;
    }

    public static class AV {
        public String attr = null;
        public String val = null;

        public String toString() {
            return "<attr=" + this.attr + ",val=" + this.val + ">";
        }
    }
}

