/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import util.Logging;

public class Logger
implements Logging {
    private Writer log = null;

    public Logger(String path) {
        if (path != null) {
            this.openLogFile(path);
        }
    }

    public void openLogFile(String path) {
        if (this.log != null) {
            this.closeLogFile();
        }
        try {
            this.log = new FileWriter(path, true);
        }
        catch (IOException iox) {
            System.out.println("openLogFile: " + iox.getMessage());
        }
    }

    public void closeLogFile() {
        if (this.log != null) {
            try {
                this.logWrite("");
                this.log.flush();
                this.log.close();
                this.log = null;
            }
            catch (IOException iox) {
                System.out.println("closeLogFile: " + iox.getMessage());
            }
        }
    }

    public void logMsg(String msg) {
        if (this.log != null) {
            try {
                String now = new Date().toString();
                this.logWrite(msg + " at " + now);
                this.log.flush();
            }
            catch (IOException iox) {
                System.out.println("logMsg: " + iox.getMessage());
            }
        }
    }

    public void logWrite(String msg) {
        if (this.log != null) {
            try {
                this.log.write(msg + "\r\n");
                this.log.flush();
            }
            catch (IOException iox) {
                System.out.println("logWrite: " + iox.getMessage());
            }
        }
    }
}

