/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class InputStreamAsBytes {
    public static boolean DO_LIST = false;
    protected static final int BUF_SZ = 1024;
    protected InputStream theStream;
    protected ArrayList<byte[]> theBlocks;
    protected int nBytes;
    protected byte[] theBytes;

    public InputStreamAsBytes(InputStream ins) throws IOException {
        this.theStream = ins;
        this.readDataBlocks();
        this.copyBlocksToBytes();
    }

    public byte[] getBytes() {
        return this.theBytes;
    }

    protected void readDataBlocks() throws IOException {
        this.theBlocks = new ArrayList();
        int n = 0;
        int b = this.theStream.read();
        while (0 <= b) {
            int nr;
            byte[] buf = new byte[1024];
            buf[0] = (byte)b;
            int i = nr = 1;
            while (0 < nr && i != 1024) {
                nr = this.theStream.read(buf, i, 1024 - i);
                if (0 >= nr) continue;
                i += nr;
            }
            this.theBlocks.add(buf);
            n += i;
            b = nr < 0 ? -1 : this.theStream.read();
        }
        this.nBytes = n;
        this.theStream.close();
    }

    protected void copyBlocksToBytes() {
        int N = this.nBytes;
        this.theBytes = new byte[N];
        int i = 0;
        int iblk = 0;
        while (i != N) {
            byte[] block = this.theBlocks.get(iblk);
            int bsz = 1024;
            if (N < i + 1024) {
                bsz = N - i;
            }
            System.arraycopy(block, 0, this.theBytes, i, bsz);
            i += bsz;
            ++iblk;
        }
        this.theBlocks.clear();
        this.theBlocks = null;
        if (DO_LIST) {
            this.listBytes();
        }
    }

    private void listBytes() {
        try {
            int i;
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)System.out, "iso-8859-1");
            PrintWriter pw = new PrintWriter((Writer)os, true);
            pw.println("#### DATA-BYTES len=" + this.nBytes);
            for (i = 0; i != this.nBytes; ++i) {
                int b = this.theBytes[i] & 0xFF;
                if (i % 8 == 0) {
                    pw.print(this.decimalStr(i, 4) + ":   ");
                }
                char ch = b < 32 ? (char)'_' : (b == 127 ? (char)'_' : (char)b);
                pw.print("|" + ch + "| " + this.decimalStr(b, 4));
                pw.print((i + 1) % 8 == 0 ? "\r\n" : "   ");
            }
            if (i % 8 != 0) {
                pw.println();
            }
            pw.flush();
        }
        catch (IOException iox) {
            System.err.println(iox.getMessage());
        }
    }

    private String decimalStr(int i, int w) {
        String istr = "" + i;
        int n = w - istr.length();
        if (0 < n) {
            StringBuilder bbuf = new StringBuilder(n);
            for (int k = 0; k != n; ++k) {
                bbuf.append(" ");
            }
            istr = bbuf.toString() + istr;
        }
        return istr;
    }
}

