/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import util.ResourceUtils;

public class HamNameMap {
    protected static final String HNS_TAG_FILE = "util/octetToHam4Tags.txt";
    protected static final String HNS_ALT_SPELL_FILE = "util/altSpellingsHam4Tags.txt";
    protected static HamNameMap hamNames = null;
    protected static final int O_MAX = 256;
    protected String[] o2h = new String[256];
    protected HashMap<String, Integer> h2o;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HamNameMap getStdHamNameMap() {
        if (hamNames != null) return hamNames;
        Class<HamNameMap> clazz = HamNameMap.class;
        synchronized (HamNameMap.class) {
            if (hamNames != null) return hamNames;
            Properties hnprops = ResourceUtils.getProperties(HNS_TAG_FILE);
            Properties hnaltspellprops = ResourceUtils.getProperties(HNS_ALT_SPELL_FILE);
            hamNames = new HamNameMap(hnprops, null, hnaltspellprops);
            // ** MonitorExit[var0] (shouldn't be in output)
            return hamNames;
        }
    }

    protected HamNameMap(Properties hnmain, Properties hnextra) {
        this(hnmain, hnextra, null);
    }

    protected HamNameMap(Properties hnmain, Properties hnextra, Properties hnaltspell) {
        this.updateO2HMap(hnmain);
        if (hnextra != null) {
            this.updateO2HMap(hnextra);
        }
        this.h2o = new HashMap();
        this.makeH2OMap();
        if (hnaltspell != null) {
            this.addAltSpellingsToH2OMap(hnaltspell);
        }
    }

    public String hamName(int o) {
        return this.o2h[o];
    }

    public String hamName(int o, String hndefault) {
        String HN = this.o2h[o];
        return HN == null ? hndefault : HN;
    }

    public int octet(String hn) {
        Integer OI = this.h2o.get(hn);
        return OI == null ? -1 : OI;
    }

    public String[] hamNames() {
        return this.h2o.keySet().toArray(new String[0]);
    }

    public String[] hamNamesAscending() {
        Comparator<String> bcomp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer I1 = HamNameMap.this.h2o.get(o1);
                Integer I2 = HamNameMap.this.h2o.get(o2);
                int cmp = 0;
                if (I1 != null && I2 == null) {
                    cmp = -1;
                } else if (I1 == null && I2 != null) {
                    cmp = 1;
                } else if (I1 != null && I2 != null) {
                    cmp = I1 - I2;
                }
                return cmp;
            }
        };
        Set<String> NAMES = this.h2o.keySet();
        int N = NAMES.size();
        String[] hnms = new String[N];
        NAMES.toArray(hnms);
        Arrays.sort(hnms, bcomp);
        return hnms;
    }

    protected void updateO2HMap(Properties hnprops) {
        Enumeration<?> hnen = hnprops.propertyNames();
        while (hnen.hasMoreElements()) {
            String ostr = (String)hnen.nextElement();
            int o = HamNameMap.s2i(ostr);
            String hn = HamNameMap.getFirstPropsToken(hnprops, ostr);
            if (!hn.startsWith("ham")) continue;
            this.o2h[o] = hn;
        }
    }

    protected void makeH2OMap() {
        for (int o = 0; o != 256; ++o) {
            String hn = this.o2h[o];
            if (hn == null || this.h2o.get(hn) != null) continue;
            this.h2o.put(new String(hn), new Integer(o));
        }
    }

    protected void addAltSpellingsToH2OMap(Properties hnaltspell) {
        Enumeration<?> asen = hnaltspell.propertyNames();
        while (asen.hasMoreElements()) {
            String altstr = (String)asen.nextElement();
            String stdstr = HamNameMap.getFirstPropsToken(hnaltspell, altstr);
            int stdval = this.octet(stdstr);
            if (0 > stdval) continue;
            this.h2o.put(altstr, stdval);
        }
    }

    protected static String getFirstPropsToken(Properties props, String istr) {
        String pstr = props.getProperty(istr);
        String pfirst = pstr.split("[ \t]+", 2)[0];
        return pfirst;
    }

    protected static int getFirstPropsInt(Properties props, String istr) {
        String valstr = HamNameMap.getFirstPropsToken(props, istr);
        return HamNameMap.s2i(valstr);
    }

    protected static int s2i(String s) {
        return Integer.decode(s);
    }
}

