/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import util.ResourceUtils;

public class HNSOctetUCSMap {
    protected static final String HNS_UNUSED = "UNUSED";
    protected static final String HNS_OCTET_UCS_PROPS_FILE = "util/HNSOctetToUnicode.txt";
    private static HNSOctetUCSMap MAP_OCTET_HIGH_UCS = null;
    private static HNSOctetUCSMap MAP_OCTET_ALL_UCS = null;
    public static final int O_NULL = 0;
    public static final int O_LIMIT = 256;
    public static final char U_NULL = '\uffff';
    protected char[] o2u = new char[256];
    protected HashMap<Character, Integer> u2o;

    public static final HNSOctetUCSMap getHNSMapOctetHighUCS() {
        return HNSOctetUCSMap.getHNSMapOctetUCS(false);
    }

    public static final HNSOctetUCSMap getHNSMapOctetAllUCS() {
        return HNSOctetUCSMap.getHNSMapOctetUCS(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final HNSOctetUCSMap getHNSMapOctetUCS(boolean DO_ALL_UCS) {
        if ((DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS) != null) return DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS;
        Class<HNSOctetUCSMap> clazz = HNSOctetUCSMap.class;
        synchronized (HNSOctetUCSMap.class) {
            if ((DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS) != null) return DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS;
            HNSOctetUCSMap newmap = new HNSOctetUCSMap(HNS_OCTET_UCS_PROPS_FILE, DO_ALL_UCS);
            if (DO_ALL_UCS) {
                MAP_OCTET_ALL_UCS = newmap;
            } else {
                MAP_OCTET_HIGH_UCS = newmap;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DO_ALL_UCS ? MAP_OCTET_ALL_UCS : MAP_OCTET_HIGH_UCS;
        }
    }

    protected HNSOctetUCSMap(String propspath, boolean DO_ALL_UCS) {
        for (int i = 0; i != 256; ++i) {
            this.o2u[i] = 65535;
        }
        Properties props = ResourceUtils.getProperties(propspath);
        Enumeration<?> pen = props.propertyNames();
        while (pen.hasMoreElements()) {
            String ostr = (String)pen.nextElement();
            int o = Integer.decode(ostr);
            int u = HNSOctetUCSMap.getFirstPropsInt(props, ostr);
            if (!DO_ALL_UCS && 256 > u) continue;
            this.o2u[o] = (char)u;
        }
        this.u2o = new HashMap(512, 0.5f);
        for (int i = 0; i != 256; ++i) {
            if (this.o2u[i] == '\uffff') continue;
            this.u2o.put(new Character(this.o2u[i]), new Integer(i));
        }
    }

    public char ucs(int o) {
        return this.o2u[o];
    }

    public String ucs(byte[] octets) {
        int N = octets.length;
        StringBuilder ubuf = new StringBuilder(N);
        for (int i = 0; i != N; ++i) {
            char u = this.o2u[octets[i]];
            if (u == '\uffff') {
                u = '?';
            }
            ubuf.setCharAt(i, u);
        }
        String ustr = ubuf.toString();
        ubuf.setLength(0);
        return ustr;
    }

    public String ucs(String ostr) {
        int N = ostr.length();
        StringBuilder ubuf = new StringBuilder(N);
        for (int i = 0; i != N; ++i) {
            char u = this.o2u[ostr.charAt(i)];
            if (u == '\uffff') {
                u = '?';
            }
            ubuf.append(u);
        }
        String ustr = ubuf.toString();
        ubuf.setLength(0);
        return ustr;
    }

    public char hns8(char u) {
        Integer oo = this.u2o.get(new Character((char)u));
        int iu = u;
        int io = oo == null ? u : oo;
        return (char)(oo == null ? u : (char)oo.intValue());
    }

    public int octet(char u) {
        int o = 0;
        Integer oo = this.u2o.get(new Character(u));
        if (oo != null) {
            o = oo;
        }
        return o;
    }

    public String octet(String ustr) {
        int N = ustr.length();
        StringBuilder obuf = new StringBuilder(N);
        for (int i = 0; i != N; ++i) {
            char u = ustr.charAt(i);
            Integer oo = this.u2o.get(new Character(u));
            char och = oo == null ? (char)'?' : (char)oo.intValue();
            obuf.append(och);
        }
        String ostr = obuf.toString();
        obuf.setLength(0);
        return ostr;
    }

    protected static int getFirstPropsInt(Properties props, String istr) {
        int val = 65535;
        String valstr = HNSOctetUCSMap.getFirstPropsToken(props, istr);
        if (valstr != null && !valstr.equals(HNS_UNUSED)) {
            try {
                val = Integer.decode(valstr);
            }
            catch (NumberFormatException nfx) {
                // empty catch block
            }
        }
        return val;
    }

    protected static String getFirstPropsToken(Properties props, String istr) {
        String[] ptoks;
        String pfirst = null;
        String pstr = props.getProperty(istr);
        if (pstr != null && (ptoks = pstr.split("[ \\t]+", 2))[0].length() != 0) {
            pfirst = ptoks[0];
        }
        return pfirst;
    }
}

