/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import util.BytesEncodingChecker;
import util.HNSOctetUCSMap;

public class HNSBytesInputConverter {
    protected byte[] input;
    protected String result;
    protected BytesEncodingChecker encCheck;

    public HNSBytesInputConverter(byte[] inb) throws IOException {
        this.input = inb;
        this.encCheck = new BytesEncodingChecker(this.input);
        if (this.encCheck.encodingIsKnown16Bit() || this.encCheck.encodingIsKnownUTF8()) {
            this.convertUCSInput();
        } else {
            this.expandBytesToString();
        }
    }

    public String getInputString() {
        return this.result;
    }

    protected void convertUCSInput() throws IOException {
        String ENC = this.encCheck.encodingIsKnown16Bit() ? this.encCheck.encodingForUCS16() : (this.encCheck.encodingIsKnownUTF8() ? "UTF-8" : "????");
        int NSKIP = this.encCheck.countBOMPrefixBytes();
        char[] inchars = this.encCheck.getDecodedString(ENC, NSKIP).toCharArray();
        HNSOctetUCSMap humap = HNSOctetUCSMap.getHNSMapOctetHighUCS();
        int N = inchars.length;
        for (int i = 0; i != N; ++i) {
            inchars[i] = humap.hns8(inchars[i]);
        }
        this.result = new String(inchars);
    }

    protected void expandBytesToString() throws IOException {
        this.result = new String(this.input, "ISO-8859-1");
    }
}

