/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.InputSource;

public class FileUtils {
    public static final InputStream newFileInputStream(String path) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
        }
        catch (IOException iox) {
            FileUtils.abort(iox);
        }
        return is;
    }

    public static final InputStream newFileInputStream(File f) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (IOException iox) {
            FileUtils.abort(iox);
        }
        return is;
    }

    public static final OutputStream newFileOutputStream(String path) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(path);
        }
        catch (IOException iox) {
            FileUtils.abort(iox);
        }
        return os;
    }

    public static final OutputStream newFileOutputStream(File f) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
        }
        catch (IOException iox) {
            FileUtils.abort(iox);
        }
        return os;
    }

    public static InputSource fileInputSource(String path) {
        return FileUtils.fileInputSource(new File(path));
    }

    public static InputSource fileInputSource(File file) {
        return new InputSource(FileUtils.urlStringForFile(file));
    }

    public static String urlStringForFile(String path) {
        return FileUtils.urlStringForFile(new File(path));
    }

    public static String urlStringForFile(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() != 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        URL furl = null;
        try {
            furl = new URL("file", "", path);
        }
        catch (MalformedURLException x) {
            FileUtils.abort(x);
        }
        return furl.toString();
    }

    public static String uriString(String path) {
        return FileUtils.uriString(new File(path));
    }

    public static String uriString(File file) {
        File absf = file.getAbsoluteFile();
        URL furi = null;
        try {
            furi = absf.toURL();
        }
        catch (MalformedURLException x) {
            FileUtils.abort(x);
        }
        return furi.toString();
    }

    public static File canonical(File f) {
        File cf = null;
        try {
            cf = f.getCanonicalFile();
        }
        catch (IOException iox) {
            FileUtils.abort(iox);
        }
        return cf;
    }

    public static final void abort(Exception x) {
        x.printStackTrace();
        System.exit(1);
    }
}

